/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.BambooCore;
import ruby.bamboo.core.PacketDispatcher;
import ruby.bamboo.core.client.KeyBindFactory;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.packet.MessageBambooUtil;

@BambooData.BambooItem(createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class Sack
extends Item
implements KeyBindFactory.IItemUtilKeylistener,
MessageBambooUtil.IMessagelistener {
    private Field remainingHighlightTicks;

    public Sack() {
        this.func_77627_a(true);
        this.func_77656_e(1025);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (itemStack.func_77978_p() == null) {
            player.func_184598_c(hand);
            player.openGui((Object)BambooCore.instance, 0, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        short count = itemStack.func_77978_p().func_74765_d("count");
        String type = itemStack.func_77978_p().func_74779_i("type");
        short meta = itemStack.func_77978_p().func_74765_d("meta");
        if (!this.isStorage(this.getItem(type))) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, player.func_70093_af());
        if (movingobjectposition == null) {
            ItemStack[] is = player.field_71071_by.field_70462_a;
            for (int i = 0; i < is.length; ++i) {
                if (is[i] == null || is[i].func_77973_b() != this.getItem(type) || is[i].func_77952_i() != meta) continue;
                if (count + is[i].field_77994_a < this.func_77612_l()) {
                    count = (short)(count + is[i].field_77994_a);
                    is[i] = null;
                    continue;
                }
                is[i].field_77994_a -= this.func_77612_l() - count - 1;
                count = (short)(this.func_77612_l() - 1);
            }
            itemStack.func_77978_p().func_74777_a("count", count);
            itemStack.func_77964_b(this.func_77612_l() - count);
        } else {
            int stacksize = ((ItemStack)this.getItem((String)type).func_77659_a((ItemStack)new ItemStack((Item)this.getItem((String)type), (int)count, (int)meta), (World)world, (EntityPlayer)player, (EnumHand)hand).func_188398_b()).field_77994_a;
            if (stacksize < count) {
                itemStack.func_77964_b(itemStack.func_77952_i() + count + stacksize);
                count = (short)(count - stacksize);
                itemStack.func_77978_p().func_74777_a("count", count);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    private Item getItem(String str) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(str));
    }

    public boolean isStorage(Item item) {
        return item instanceof ItemBlock ? true : (item instanceof ItemSeeds ? true : item instanceof ItemSeedFood);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack.func_77978_p() == null) {
            return EnumActionResult.FAIL;
        }
        short count = stack.func_77978_p().func_74765_d("count");
        String type = stack.func_77978_p().func_74779_i("type");
        short meta = stack.func_77978_p().func_74765_d("meta");
        if (!this.isStorage(this.getItem(type))) {
            return EnumActionResult.FAIL;
        }
        if (!world.canMineBlockBody(player, pos)) {
            return EnumActionResult.FAIL;
        }
        if (count != 0) {
            ItemStack is = new ItemStack(this.getItem(type), 1, (int)meta);
            if (Block.func_149634_a((Item)this.getItem(type)) != Blocks.field_150350_a && this.getItem(type) instanceof ItemBlock && this.getItem(type).func_180614_a(is, player, world, pos, hand, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                stack.func_77964_b(stack.func_77952_i() + 1);
                count = (short)(count - 1);
                stack.func_77978_p().func_74777_a("count", count);
                player.func_184609_a(hand);
            }
            if (this.getItem(type) instanceof ItemSeeds || this.getItem(type) instanceof ItemSeedFood) {
                for (BlockPos targetPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 0, 2))) {
                    if (this.getItem(type).func_180614_a(is, player, world, targetPos, hand, facing, hitX, hitY, hitZ) != EnumActionResult.SUCCESS) continue;
                    stack.func_77964_b(stack.func_77952_i() + 1);
                    count = (short)(count - 1);
                    stack.func_77978_p().func_74777_a("count", count);
                    player.func_184609_a(hand);
                    if (count >= 1) continue;
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void release(ItemStack itemStack, EntityPlayer player) {
        World world = player.func_130014_f_();
        if (itemStack.func_77978_p() != null && !world.field_72995_K) {
            short count = itemStack.func_77978_p().func_74765_d("count");
            String type = itemStack.func_77978_p().func_74779_i("type");
            short meta = itemStack.func_77978_p().func_74765_d("meta");
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            if (count > 0) {
                player.func_70099_a(new ItemStack(this.getItem(type), (int)count, (int)meta), 0.5f);
                count = 0;
            }
            this.clearContainer(itemStack);
            itemStack.func_77964_b(0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderToolHighlight() {
        try {
            if (this.remainingHighlightTicks == null) {
                for (int i = 0; i < GuiIngame.class.getDeclaredFields().length; ++i) {
                    if (GuiIngame.class.getDeclaredFields()[i].getType() != ItemStack.class) continue;
                    this.remainingHighlightTicks = GuiIngame.class.getDeclaredFields()[i - 1];
                }
                this.remainingHighlightTicks.setAccessible(true);
            }
            this.remainingHighlightTicks.setInt(FMLClientHandler.instance().getClient().field_71456_v, 40);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String name = super.func_77653_i(par1ItemStack);
        if (par1ItemStack.func_77978_p() != null && this.getItem(par1ItemStack.func_77978_p().func_74779_i("type")) != null) {
            name = name + (":" + this.getItem(par1ItemStack.func_77978_p().func_74779_i("type")).func_77653_i(new ItemStack(this.getItem(par1ItemStack.func_77978_p().func_74779_i("type")), 1, (int)par1ItemStack.func_77978_p().func_74765_d("meta"))) + ":" + par1ItemStack.func_77978_p().func_74765_d("count")).trim();
        }
        return name;
    }

    public void func_77663_a(ItemStack stack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par5 && par2World.field_72995_K) {
            this.renderToolHighlight();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return par1ItemStack.func_77978_p() != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return null;
        }
        short count = itemStack.func_77978_p().func_74765_d("count");
        String type = itemStack.func_77978_p().func_74779_i("type");
        short meta = itemStack.func_77978_p().func_74765_d("meta");
        return new ItemStack(this.getItem(type), (int)count, (int)meta);
    }

    public void setContainerItem(ItemStack from, ItemStack to) {
        if (from == null || to == null) {
            return;
        }
        if (from.func_77978_p() == null) {
            from.func_77982_d(new NBTTagCompound());
        }
        from.func_77978_p().func_74778_a("type", String.valueOf(Item.field_150901_e.func_177774_c((Object)to.func_77973_b())));
        from.func_77978_p().func_74777_a("count", (short)to.field_77994_a);
        from.func_77978_p().func_74777_a("meta", (short)to.func_77952_i());
    }

    public void clearContainer(ItemStack itemStack) {
        itemStack.func_77982_d(null);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    @Override
    public void exec(KeyBinding key) {
        if (key.func_151468_f()) {
            PacketDispatcher.sendToServer(new MessageBambooUtil());
        }
    }

    @Override
    public void call(EntityPlayer player, ItemStack is, byte data) {
        this.release(is, player);
    }
}

