/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.packet;

import com.google.common.primitives.Bytes;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ruby.bamboo.enchant.EnchantFactory;
import ruby.bamboo.enchant.IBambooEnchantable;
import ruby.bamboo.gui.ContainerPickaxeName;
import ruby.bamboo.gui.GuiHandler;

public class MessagePickaxe
implements IMessage {
    public byte[] data;
    private final byte[] empty = new byte[]{0};

    public MessagePickaxe() {
    }

    public MessagePickaxe(byte guiID) {
        this.data = new byte[]{guiID};
    }

    public MessagePickaxe setSubData(String data) {
        try {
            this.data = Bytes.concat((byte[][])new byte[][]{this.data, this.empty, data.getBytes("UTF-8")});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public MessagePickaxe setSubData(byte data) {
        this.data = Bytes.concat((byte[][])new byte[][]{this.data, this.empty, {data}});
        return this;
    }

    public boolean hasSubdata() {
        return this.data.length > 1;
    }

    public byte getGuiID() {
        return this.data[0];
    }

    private byte[] getSubData() {
        return this.hasSubdata() ? Arrays.copyOfRange(this.data, 2, this.data.length) : this.empty;
    }

    public byte getSubDataToByte() {
        return this.getSubData()[0];
    }

    public String getSubDataToString() {
        try {
            return new String(this.getSubData(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.data = new byte[buf.readableBytes()];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBytes(this.data);
    }

    public static interface IMessagelistener {
        public void call(EntityPlayer var1, ItemStack var2, byte var3);
    }

    public static class MessagePickaxeHandler
    implements IMessageHandler<MessagePickaxe, IMessage> {
        public IMessage onMessage(MessagePickaxe message, MessageContext ctx) {
            if (!message.hasSubdata()) {
                GuiHandler.openGui((EntityPlayer)ctx.getServerHandler().field_147369_b, message.getGuiID());
            } else {
                switch (message.getGuiID()) {
                    case 4: {
                        this.onGuiLvSub(ctx.getServerHandler().field_147369_b, message.getSubDataToByte());
                        break;
                    }
                    case 5: {
                        this.onGuiNameSub(ctx.getServerHandler().field_147369_b, message.getSubDataToString());
                        break;
                    }
                    case 6: {
                        this.onGuiEnchSub(ctx.getServerHandler().field_147369_b, message.getSubDataToByte());
                    }
                }
            }
            return null;
        }

        private void onGuiLvSub(EntityPlayerMP playerEntity, byte data) {
            EnchantFactory.setEnchant(playerEntity.func_184614_ca(), data);
        }

        private void onGuiNameSub(EntityPlayerMP playerEntity, String name) {
            ContainerPickaxeName container = (ContainerPickaxeName)playerEntity.field_71070_bA;
            container.updateItemName(name);
        }

        private void onGuiEnchSub(EntityPlayerMP playerEntity, byte data) {
            ItemStack stack = playerEntity.func_184614_ca();
            List<NBTTagCompound> nbtList = IBambooEnchantable.getSpenchList(stack);
            if (data < nbtList.size()) {
                nbtList.get(data).func_74757_a("enable", !nbtList.get(data).func_74767_n("enable"));
            }
        }
    }
}

