/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.plugin.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.crafting.CookingManager;
import ruby.bamboo.crafting.GrindManager;
import ruby.bamboo.plugin.jei.CookingRecipeCategory;
import ruby.bamboo.plugin.jei.CookingRecipeHandler;
import ruby.bamboo.plugin.jei.GrindRecipeCategory;
import ruby.bamboo.plugin.jei.GrindRecipeHandler;
import ruby.bamboo.util.ItemStackHelper;

@JEIPlugin
public class BambooJEIPlugin
implements IModPlugin {
    private IJeiHelpers helper;

    public void register(IModRegistry registry) {
        this.helper = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new GrindRecipeCategory(this.helper.getGuiHelper()), new CookingRecipeCategory(this.helper.getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new GrindRecipeHandler(), new CookingRecipeHandler()});
        registry.addRecipes((List)Lists.newArrayList(GrindManager.getRecipeList()));
        registry.addRecipes(CookingManager.getInstance().getRecipeList().stream().filter(rec -> !rec.hasEmptyList()).collect(Collectors.toList()));
        registry.addRecipeCategoryCraftingItem(new ItemStack(BambooBlocks.CAMPFIRE), new String[]{"bamboo.jei.campfire"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BambooBlocks.MILLSTONE), new String[]{"bamboo.jei.millstone"});
        HashSet blackList = Sets.newHashSet();
        blackList.addAll(StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(i -> i.getClass().isAnnotationPresent(BambooData.JEIIgnore.class)).map(i -> new ItemStackHelper.HashedStack((Item)i)).collect(Collectors.toList()));
        blackList.addAll(StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(i -> i.getClass().isAnnotationPresent(BambooData.JEIIgnore.class)).map(i -> new ItemStackHelper.HashedStack((Block)i)).collect(Collectors.toList()));
        for (ItemStackHelper.HashedStack is : blackList) {
            this.helper.getItemBlacklist().addItemToBlacklist(is.getItemStack());
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

