/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.proxy;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLLog;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.block.IBlockColorWrapper;
import ruby.bamboo.block.ICustomState;
import ruby.bamboo.block.decoration.DecorationClientFactory;
import ruby.bamboo.core.client.KeyBindFactory;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EntityRegister;
import ruby.bamboo.item.itemblock.IEnumTex;
import ruby.bamboo.item.itemblock.IItemColorWrapper;
import ruby.bamboo.item.itemblock.ISubTexture;
import ruby.bamboo.proxy.CommonProxy;
import ruby.bamboo.texture.TextureHelper;
import ruby.bamboo.tileentity.TileCampfire;
import ruby.bamboo.tileentity.TileMillStone;
import ruby.bamboo.tileentity.render.RenderCampfire;
import ruby.bamboo.tileentity.render.RenderMillStone;

public class ClientProxy
extends CommonProxy {
    Map<ModelResourceLocation, Item> modelMap = Maps.newHashMap();

    @Override
    public void preInit() {
        super.preInit();
        this.registJson();
        new DecorationClientFactory().register();
        new EntityRegister().renderRegist();
        this.registTileRender();
        KeyBindFactory.preInit();
    }

    @Override
    public void init() {
        super.init();
        KeyBindFactory.init();
        MinecraftForge.EVENT_BUS.register((Object)BambooItems.BAMBOO_BOW);
        this.registColors();
        new TextureHelper(this.modelMap);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registedList = null;
    }

    private void registJson() {
        ArrayList isList = new ArrayList();
        ArrayList tmpNameList = new ArrayList();
        for (String name : this.registedList) {
            ModelResourceLocation mrl;
            Block block = Block.func_149684_b((String)name);
            Item item = Item.func_111206_d((String)name);
            isList.clear();
            item.func_150895_a(item, item.func_77640_w(), isList);
            this.setIgnoreState(block);
            IStateMapper state = this.setCustomState(block);
            if (block instanceof BlockFluidBase) {
                final ModelResourceLocation mrl2 = new ModelResourceLocation(name, "fluid");
                ModelLoader.setCustomMeshDefinition((Item)item, is -> mrl2);
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                    protected ModelResourceLocation func_178132_a(IBlockState state) {
                        return mrl2;
                    }
                });
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl2});
                continue;
            }
            if (block != null && state != null) {
                String jsonName = name;
                BambooData.BambooBlock anoData = block.getClass().getAnnotation(BambooData.BambooBlock.class);
                if (anoData != null && !anoData.jsonName().isEmpty()) {
                    jsonName = anoData.jsonName();
                }
                mrl = new ModelResourceLocation(jsonName, "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
                Map map = state.func_178130_a(block);
                for (ModelResourceLocation m : map.values()) {
                    this.modelMap.put(m, item);
                }
                continue;
            }
            if (item instanceof ISubTexture) {
                for (IEnumTex tex : ((ISubTexture)item).getName()) {
                    String jsonName = tex.getJsonName();
                    ModelResourceLocation mrl3 = new ModelResourceLocation(jsonName, "inventory");
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)tex.getId(), (ModelResourceLocation)mrl3);
                    this.modelMap.put(mrl3, item);
                }
                continue;
            }
            for (int i = 0; i < isList.size(); ++i) {
                BambooData.BambooBlock anoData;
                String jsonName = name;
                if (block != null && (anoData = block.getClass().getAnnotation(BambooData.BambooBlock.class)) != null && !anoData.jsonName().isEmpty()) {
                    jsonName = "bamboomod:" + anoData.jsonName();
                }
                mrl = new ModelResourceLocation(jsonName, "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)mrl);
                this.modelMap.put(mrl, item);
            }
        }
    }

    public String getPropertyString(Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(this.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    private IStateMapper setCustomState(Block block) {
        if (block instanceof ICustomState) {
            try {
                IStateMapper state = (IStateMapper)((ICustomState)block).getCustomState();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)state);
                return state;
            }
            catch (Exception e) {
                FMLLog.warning((String)(block.getClass().getName() + ": Custom State Error"), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private <T> void setIgnoreState(T obj) {
        Method method = this.getMethod(obj, BambooData.BambooBlock.StateIgnore.class);
        if (method != null) {
            try {
                IProperty[] prop = (IProperty[])method.invoke(obj, new Object[0]);
                if (prop != null) {
                    ModelLoader.setCustomStateMapper((Block)((Block)obj), (IStateMapper)new StateMap.Builder().func_178442_a(prop).func_178441_a());
                }
            }
            catch (Exception e) {
                FMLLog.warning((String)(obj.getClass().getName() + "Ignore State Error"), (Object[])new Object[0]);
            }
        }
    }

    private <T> Method getMethod(T obj, Class<? extends Annotation> ano) {
        if (obj == null) {
            return null;
        }
        Method method = null;
        for (Method e : obj.getClass().getDeclaredMethods()) {
            if (e.getAnnotation(ano) == null) continue;
            method = e;
            break;
        }
        return method;
    }

    private void registColors() {
        List<Block> colorBlockList = this.registedList.stream().map(Block::func_149684_b).filter(ins -> ins instanceof IBlockColorWrapper).collect(Collectors.toList());
        List<Item> colorItemList = this.registedList.stream().map(Item::func_111206_d).filter(ins -> ins instanceof IItemColorWrapper).collect(Collectors.toList());
        colorBlockList.forEach(colorBlock -> Minecraft.func_71410_x().func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> ((IBlockColorWrapper)colorBlock).colorMultiplier(state, worldIn, pos, tintIndex), new Block[]{colorBlock}));
        colorItemList.forEach(colorItem -> Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> ((IItemColorWrapper)colorItem).getColorFromItemstack(stack, tintIndex), new Item[]{colorItem}));
    }

    private void registTileRender() {
        this.registTESR(Item.func_150898_a((Block)BambooBlocks.CAMPFIRE), TileCampfire.class, new RenderCampfire());
        this.registTESR(Item.func_150898_a((Block)BambooBlocks.MILLSTONE), TileMillStone.class, new RenderMillStone());
    }

    private void registTESR(Item item, Class<? extends TileEntity> cls, TileEntitySpecialRenderer render) {
        ClientRegistry.bindTileEntitySpecialRenderer(cls, (TileEntitySpecialRenderer)render);
        ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, cls);
    }

    @Override
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }
}

