/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.proxy;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ruby.bamboo.block.decoration.DecorationFactory;
import ruby.bamboo.core.BambooCore;
import ruby.bamboo.core.PacketDispatcher;
import ruby.bamboo.core.init.DataLoader;
import ruby.bamboo.core.init.EntityRegister;
import ruby.bamboo.crafting.BambooRecipes;
import ruby.bamboo.crafting.CraftingHandler;
import ruby.bamboo.fluid.HotSpring;
import ruby.bamboo.generate.GenerateHandler;
import ruby.bamboo.gui.GuiHandler;
import ruby.bamboo.tileentity.TileCampfire;
import ruby.bamboo.tileentity.TileJPChest;
import ruby.bamboo.tileentity.TileMillStone;
import ruby.bamboo.tileentity.TileSpringWater;

public class CommonProxy {
    List<String> registedList = Lists.newArrayList();

    public void preInit() {
        this.registerFluid();
        try {
            FMLLog.info((String)"********** BambooMod Data Init Start **********", (Object[])new Object[0]);
            DataLoader loader = new DataLoader();
            this.registedList.addAll(loader.init("ruby.bamboo.block"));
            new DecorationFactory().register();
            this.registedList.addAll(loader.init("ruby.bamboo.item"));
            FMLLog.info((String)"********** BambooMod Data Init END **********", (Object[])new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GenerateHandler gen = new GenerateHandler();
        GameRegistry.registerWorldGenerator((IWorldGenerator)gen, (int)1);
        MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
        this.registTileEntity();
        new EntityRegister().entityRegist();
        PacketDispatcher.init();
    }

    public void init() {
        this.registRecipe();
    }

    public void postInit() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)BambooCore.instance, (IGuiHandler)new GuiHandler());
    }

    private void registRecipe() {
        BambooRecipes recipeIns = new BambooRecipes();
        recipeIns.addRecipes();
    }

    private void registerFluid() {
        FluidRegistry.registerFluid((Fluid)new HotSpring());
    }

    private void registTileEntity() {
        GameRegistry.registerTileEntity(TileJPChest.class, (String)"jpchest");
        GameRegistry.registerTileEntity(TileSpringWater.class, (String)"spring_water");
        GameRegistry.registerTileEntity(TileCampfire.class, (String)"campfire");
        GameRegistry.registerTileEntity(TileMillStone.class, (String)"millstone");
    }

    public EntityPlayer getPlayer() {
        return null;
    }
}

