/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ruby.bamboo.texture.IMultiTextuerBlock;
import ruby.bamboo.texture.IMultiTextuerItem;

public class TextureHelper {
    final Map<ModelResourceLocation, Item> modelLocMap;

    public TextureHelper(Map<ModelResourceLocation, Item> modelMap) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.modelLocMap = ImmutableMap.copyOf(modelMap);
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent event) {
        try {
            for (ModelResourceLocation ml : event.getModelRegistry().func_148742_b()) {
                if (!ml.func_110624_b().equals("bamboomod")) continue;
                Block block = Block.func_149684_b((String)("bamboomod:" + ml.func_110623_a()));
                Item item = this.modelLocMap.get(ml);
                if (ml.func_177518_c().equals("inventory")) {
                    IBakedModel bakedModel;
                    if (!(item instanceof IMultiTextuerItem) || !((bakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)ml)) instanceof IPerspectiveAwareModel)) continue;
                    Map<Integer, String> texMap = ((IMultiTextuerItem)item).getTexName();
                    String jsonCode = "{'elements':[{'from':[0,0,0],'to':[16,16,16],'faces':{'down':{'uv':[0,0,16,16],'texture':''}}}],'display':{'ground':{'rotation':[0,0,0],'translation':[0,2,0],'scale':[0.5,0.5,0.5]},'head':{'rotation':[0,180,0],'translation':[0,13,7],'scale':[1,1,1]},'thirdperson_righthand':{'rotation':[0,0,0],'translation':[0,3,1],'scale':[0.55,0.55,0.55]},'firstperson_righthand':{'rotation':[0,-90,25],'translation':[1.13,3.2,1.13],'scale':[0.68,0.68,0.68]}}}";
                    ModelBlock model = ModelBlock.func_178294_a((String)jsonCode.replaceAll("'", "\""));
                    HashMap modelMap = Maps.newHashMap();
                    OverrideListWrapper ovrList = new OverrideListWrapper((List<ItemOverride>)model.func_187967_g().getOverrides()).setModelMap(modelMap);
                    ItemLayerModel rawModel = new ItemLayerModel(ImmutableList.of(), (ItemOverrideList)ovrList);
                    ItemCameraTransforms transforms = model.func_181682_g();
                    HashMap tMap = Maps.newHashMap();
                    tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)transforms));
                    tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)rawModel.getDefaultState()));
                    SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
                    for (Map.Entry<Integer, String> entry : texMap.entrySet()) {
                        modelMap.put(entry.getKey(), rawModel.retexture(ImmutableMap.of((Object)"layer0", (Object)entry.getValue())).bake((IModelState)perState, DefaultVertexFormats.field_176599_b, rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString())));
                    }
                    event.getModelRegistry().func_82595_a((Object)ml, (Object)rawModel.bake((IModelState)perState, DefaultVertexFormats.field_176599_b, rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString())));
                    continue;
                }
                if (!(block instanceof IMultiTextuerBlock)) continue;
                IModel rawModel = ModelLoaderRegistry.getModel((ResourceLocation)ml);
                event.getModelRegistry().func_82595_a((Object)ml, (Object)new BakedWrapper(rawModel));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        HashSet texSet = Sets.newHashSet();
        for (Map.Entry<ModelResourceLocation, Item> e : this.modelLocMap.entrySet()) {
            if (!(e.getValue() instanceof IMultiTextuerItem)) continue;
            for (Map.Entry<Integer, String> e2 : ((IMultiTextuerItem)e.getValue()).getTexName().entrySet()) {
                texSet.add(e2.getValue());
            }
        }
        TextureMap textureMap = event.getMap();
        for (String s : texSet) {
            ResourceLocation ret = new ResourceLocation(s);
            textureMap.func_174942_a(ret);
        }
        texSet.clear();
    }

    class BakedWrapper
    implements IBakedModel {
        IBakedModel bakedModel;
        IModel rawModel;

        BakedWrapper(IModel rawModel) {
            this.rawModel = rawModel;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (this.bakedModel == null) {
                String texPath = ((IMultiTextuerBlock)state.func_177230_c()).getTexName(state, side);
                this.bakedModel = this.rawModel.bake(this.rawModel.getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(texPath));
            }
            return this.bakedModel.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_177555_b();
            }
            return false;
        }

        public boolean func_177556_c() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_177556_c();
            }
            return false;
        }

        public boolean func_188618_c() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_188618_c();
            }
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_177554_e();
            }
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }

        public ItemCameraTransforms func_177552_f() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_177552_f();
            }
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            if (this.bakedModel != null) {
                return this.bakedModel.func_188617_f();
            }
            return ItemOverrideList.field_188022_a;
        }
    }

    class OverrideListWrapper
    extends ItemOverrideList {
        public Map<Integer, IBakedModel> modelMap;

        public OverrideListWrapper(List<ItemOverride> overridesIn) {
            super(overridesIn);
        }

        public OverrideListWrapper setModelMap(Map<Integer, IBakedModel> map) {
            this.modelMap = map;
            return this;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (this.modelMap != null && this.modelMap.containsKey(stack.func_77952_i())) {
                return this.modelMap.get(stack.func_77952_i());
            }
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }
}

