/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ruby.bamboo.block.Campfire;
import ruby.bamboo.crafting.CookingManager;

public class TileCampfire
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final byte SLOT_FUEL = 9;
    private static final byte SLOT_RESULT = 10;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static final int[] slotsSides = new int[]{9};
    private ItemStack[] slots = new ItemStack[11];
    private ItemStack[] copyMatrix = new ItemStack[9];
    private static final int MAX_FUEL = 102400;
    private int fuel;
    private int maxCookTime = 200;
    private int cookTime = 200;
    private boolean isBurn = false;
    private CookingManager.RecipeEntry entry;
    public ItemStack nowCookingResult;
    public int fuelRatio;
    public int cookRatio = 100;
    private int meatroll;
    private BakeType nowBakeType = BakeType.NONE;

    public void func_73660_a() {
        this.updateFuel();
        this.updateCooking();
        this.updateRender();
    }

    private void updateFuel() {
        int slotFuel;
        if (!this.func_145831_w().field_72995_K && TileEntityFurnace.func_145954_b((ItemStack)this.slots[9]) && this.fuel + (slotFuel = TileEntityFurnace.func_145952_a((ItemStack)this.slots[9])) <= 102400) {
            this.fuel += slotFuel;
            if (--this.slots[9].field_77994_a == 0) {
                this.slots[9] = this.slots[9].func_77973_b().getContainerItem(this.slots[9]);
            }
        }
    }

    private void updateCooking() {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.isBurn && !this.isEmpty()) {
                if (this.slots[10] != null && this.slots[10].field_77994_a == this.slots[10].func_77976_d()) {
                    return;
                }
                if (this.canCooking() && this.entry.getFuelCost() <= this.fuel && this.nowCookingResult != null) {
                    if (this.slots[10] == null) {
                        this.isBurn = true;
                        this.maxCookTime = this.cookTime = this.getCookTime();
                        this.setMatrix();
                    } else if (this.nowCookingResult.func_77969_a(this.slots[10]) && this.slots[10].field_77994_a + this.nowCookingResult.field_77994_a <= this.slots[10].func_77976_d()) {
                        this.isBurn = true;
                        this.maxCookTime = this.cookTime = this.getCookTime();
                        this.setMatrix();
                    }
                }
            } else {
                this.updateBurn();
            }
        }
    }

    private void updateBurn() {
        if (!this.func_145831_w().field_72995_K && this.isBurn) {
            if (--this.cookTime <= 0) {
                CookingManager.RecipeEntry entry;
                ItemStack nowMatrix;
                if (this.nowCookingResult != null && (nowMatrix = (entry = CookingManager.getInstance().findMatchingRecipe(this.slots, this.func_145831_w())).getItemStack()) != null && nowMatrix.func_77969_a(this.nowCookingResult)) {
                    if (this.slots[10] == null) {
                        this.materialConsumption(entry);
                        this.slots[10] = this.nowCookingResult.func_77946_l();
                    } else if (this.nowCookingResult.func_77969_a(this.slots[10]) && this.slots[10].field_77994_a + this.nowCookingResult.field_77994_a <= this.slots[10].func_77976_d()) {
                        this.materialConsumption(entry);
                        this.slots[10].field_77994_a += this.nowCookingResult.field_77994_a;
                    }
                    this.func_70296_d();
                }
                this.nowCookingResult = null;
                this.isBurn = false;
                this.maxCookTime = this.cookTime = this.getCookTime();
            }
            if ((this.cookTime & 1) == 0 && !this.chkMtrix()) {
                this.nowCookingResult = null;
                this.isBurn = false;
                this.cookTime = 200;
                this.maxCookTime = 200;
            }
            if (this.cookTime % 100 == 0) {
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 7);
            }
        }
    }

    void updateRender() {
        int n = this.meatroll = this.meatroll < 360 ? (this.meatroll = this.meatroll + 1) : 0;
        if (!this.field_145850_b.field_72995_K) {
            BakeType type = BakeType.NONE;
            if (this.func_70301_a(10) != null) {
                type = this.func_70301_a(10).func_77973_b() == Items.field_179566_aV ? BakeType.FISH : (this.func_70301_a(10).func_77973_b() == Items.field_151157_am || this.func_70301_a(10).func_77973_b() == Items.field_151083_be ? BakeType.MEAT : BakeType.ATHER);
            }
            if (this.nowBakeType != type) {
                this.nowBakeType = type;
                this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
        }
    }

    private int getCookTime() {
        return this.entry.getTotalCookTime();
    }

    private boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean canCooking() {
        this.entry = CookingManager.getInstance().findMatchingRecipe(this.slots, this.func_145831_w());
        return this.entry != null && (this.nowCookingResult = this.entry.getItemStack()) != null;
    }

    private void setMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.copyMatrix[i] = this.func_70301_a(i);
        }
    }

    private boolean chkMtrix() {
        for (int i = 0; i < 9; ++i) {
            if (this.copyMatrix[i] == this.slots[i]) continue;
            return false;
        }
        return true;
    }

    private void materialConsumption(CookingManager.RecipeEntry entry) {
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null || --this.slots[i].field_77994_a != 0) continue;
            this.slots[i] = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
        }
        this.fuel -= entry.getFuelCost();
    }

    public BakeType getBakeType() {
        return this.nowBakeType;
    }

    public float getRotate() {
        switch ((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(Campfire.FACING)) {
            case NORTH: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public int getMeatroll() {
        return this.meatroll;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("fuel");
        this.cookTime = nbt.func_74762_e("cookTime");
        this.maxCookTime = nbt.func_74762_e("maxCookTime");
        if (nbt.func_74764_b("nowItem")) {
            this.nowCookingResult = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("nowItem")));
        }
        NBTTagList nbtList = new NBTTagList();
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < this.slots.length && i < list.func_74745_c(); ++i) {
            NBTTagCompound nbtCompound = list.func_150305_b(i);
            if (!nbtCompound.func_74764_b("itemNBT")) continue;
            this.slots[i] = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbtCompound.func_74781_a("itemNBT")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74768_a("cookTime", this.cookTime);
        nbt.func_74768_a("maxCookTime", this.maxCookTime);
        if (this.nowCookingResult != null) {
            nbt.func_74782_a("nowItem", (NBTBase)this.nowCookingResult.func_77955_b(new NBTTagCompound()));
        }
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < this.slots.length; ++i) {
            NBTTagCompound nbtCompound = new NBTTagCompound();
            if (this.slots[i] != null) {
                NBTTagCompound itemCompound = new NBTTagCompound();
                this.slots[i].func_77955_b(itemCompound);
                nbtCompound.func_74782_a("itemNBT", (NBTBase)itemCompound);
            }
            list.func_74742_a((NBTBase)nbtCompound);
        }
        return nbt;
    }

    public ItemStack[] getInventorySlots() {
        return this.slots;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.fuel;
            }
            case 1: {
                return this.maxCookTime;
            }
            case 2: {
                return this.cookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.maxCookTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.slots[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack itemstack = null;
        if (this.slots[var1] != null) {
            if (this.slots[var1].field_77994_a <= var2) {
                itemstack = this.slots[var1];
                this.slots[var1] = null;
            } else {
                itemstack = this.slots[var1].func_77979_a(var2);
                if (this.slots[var1].field_77994_a == 0) {
                    this.slots[var1] = null;
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.slots[var1] != null) {
            ItemStack itemstack = this.slots[var1];
            this.slots[var1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.slots[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "bamboo.container.campfire";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : var1.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 == 2 ? false : (var1 == 9 ? TileEntityFurnace.func_145954_b((ItemStack)var2) : true);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return stack.func_77973_b() == Items.field_151133_ar || index == 10;
    }

    public int getCookAmount() {
        return this.getRatio(this.cookTime, this.maxCookTime, 100);
    }

    public int getFuelAmount() {
        return this.getRatio(this.fuel, 102400.0f, 100);
    }

    private int getRatio(float par0, float par1, int par3) {
        return Math.round(par0 / par1 * (float)par3);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.writeData(var1);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, var1);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readData(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeData(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readData(tag);
    }

    private NBTTagCompound writeData(NBTTagCompound tag) {
        tag.func_74778_a("bakeType", this.nowBakeType.name());
        tag.func_74768_a("time", this.cookTime);
        tag.func_74768_a("maxtime", this.maxCookTime);
        return tag;
    }

    private void readData(NBTTagCompound tag) {
        String str = tag.func_74779_i("bakeType");
        if (!str.isEmpty()) {
            this.nowBakeType = BakeType.valueOf(str);
        }
        this.cookTime = tag.func_74762_e("time");
        this.maxCookTime = tag.func_74762_e("maxTIme");
    }

    public static enum BakeType {
        NONE,
        ATHER,
        MEAT,
        FISH;

    }
}

