/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.util;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BlockDestroyHelper {
    private World world;
    private LinkedList<BlockPos> list;

    private BlockDestroyHelper(World world, LinkedList<BlockPos> list) {
        this.world = world;
        this.list = list;
    }

    public static void addQueue(World target, Iterable<BlockPos> c) {
        LinkedList list = Lists.newLinkedList(c);
        MinecraftForge.EVENT_BUS.register((Object)new BlockDestroyHelper(target, list));
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent e) {
        if (!e.world.field_72995_K && e.world == this.world) {
            if (this.list != null && !this.list.isEmpty()) {
                BlockPos pos = this.list.poll();
                if (this.world.func_180495_p(pos).func_177230_c().func_176195_g(this.world.func_180495_p(pos), this.world, pos) > 0.0f) {
                    e.world.func_175655_b(pos, true);
                }
            } else {
                this.list.clear();
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }
}

