/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;

public class ItemStackHelper {
    private static final int armorSlotCount = 0;

    public static boolean hasDecrStackSize(IInventory inv, ItemStack stack, int count) {
        return ItemStackHelper.getInventoryStackSize(inv, stack) >= count;
    }

    public static int getInventoryStackSize(IInventory inv, ItemStack stack) {
        int invCount = 0;
        for (int i = 0; i < inv.func_70302_i_() - 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            invCount += is.field_77994_a;
        }
        return invCount;
    }

    public static int getInventoryStackSize(ItemStack[] inv, ItemStack stack) {
        return (int)Stream.of(inv).map(is -> stack.func_77969_a(is)).count();
    }

    public static boolean decrStackSize(IInventory inv, ItemStack stack, int count) {
        if (!ItemStackHelper.hasDecrStackSize(inv, stack, count)) {
            return false;
        }
        for (int i = inv.func_70302_i_() - 0; 0 <= i && count > 0; --i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            if ((count -= is.field_77994_a) >= 0) {
                inv.func_70299_a(i, null);
                continue;
            }
            inv.func_70298_a(i, count + is.field_77994_a);
        }
        return true;
    }

    public static int getSlotNum(IInventory inv, ItemStack stack) {
        for (int i = inv.func_70302_i_() - 0; 0 <= i; --i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            return i;
        }
        return -1;
    }

    public static <T extends NBTBase> Iterable<T> getNBTTagListIte(final NBTTagList tagList) {
        return () -> new Iterator<T>(){
            int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != tagList.func_74745_c();
            }

            @Override
            public T next() {
                int i = this.cursor;
                if (i >= tagList.func_74745_c()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                return tagList.func_179238_g(i);
            }

            @Override
            public void remove() {
                int i = this.cursor;
                if (i >= tagList.func_74745_c()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i - 1;
                tagList.func_74744_a(i);
            }
        };
    }

    public static EnumHand getHandItemEq(EntityPlayer player, Item target) {
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == target ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public static class HashedStack {
        public final Item item;
        public final int damage;
        public final int stackSize;

        public HashedStack(Item item) {
            this(new ItemStack(item));
        }

        public HashedStack(Block block) {
            this(new ItemStack(block));
        }

        public HashedStack(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.damage = stack.func_77952_i();
            this.stackSize = stack.field_77994_a;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof HashedStack) {
                return super.equals(obj) || this.hashCode() == obj.hashCode();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.damage);
        }

        public ItemStack getItemStack() {
            return new ItemStack(this.item, this.stackSize, this.damage);
        }
    }
}

