/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagListEx<E extends NBTBase>
extends NBTTagList
implements Collection<E> {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<NBTBase> tagList = Lists.newArrayList();

    public NBTTagListEx(NBTTagList parent) {
        for (Field f : NBTTagList.class.getDeclaredFields()) {
            if (!List.class.isInstance(f.getType())) continue;
            f.setAccessible(true);
            try {
                this.tagList = (List)f.get(parent);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int size() {
        return this.tagList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tagList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.tagList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.tagList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.tagList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.tagList.toArray(a);
    }

    @Override
    public boolean add(E e) {
        int size = this.tagList.size();
        this.func_74742_a((NBTBase)e);
        return this.tagList.size() != size;
    }

    @Override
    public boolean remove(Object o) {
        return this.tagList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.tagList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        ArrayList clone = Lists.newArrayList(this.tagList);
        for (NBTBase e : c) {
            if (clone.add(e)) continue;
            return false;
        }
        this.tagList = clone;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.tagList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.tagList.retainAll(c);
    }

    @Override
    public void clear() {
        this.tagList.clear();
    }
}

