/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import ruby.bamboo.item.ItemBambooPickaxe;
import ruby.bamboo.item.ItemSack;
import ruby.bamboo.item.enchant.BambooEnchantment;
import ruby.bamboo.item.enchant.EnchantBase;

public class CraftingHandler {
    private static final String[] nameTable = new String[]{"hero", "beast", "lily", "old", "shine", "admired", "nomal", "cool", "subtle", "toy", "alive", "hope"};
    private static final String[] tyoeTable = new String[]{"pickaxe", "shadow", "mass", "breaker", "cracker", "stinger", "drop", "oath", "precept", "sin"};

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.crafting.func_77973_b() instanceof ItemSack) {
            int lim = event.craftMatrix.func_70302_i_();
            while (lim-- > 0) {
                Item target;
                if (event.craftMatrix.func_70301_a(lim) == null || !((target = event.craftMatrix.func_70301_a(lim).func_77973_b()) instanceof ItemSack)) continue;
                ((ItemSack)target).release(event.craftMatrix.func_70301_a(lim), event.player.field_70170_p, event.player);
            }
        } else if (event.crafting.func_77973_b() instanceof ItemBambooPickaxe) {
            float reality = 0.0f;
            Random rand = event.player.field_70170_p.field_73012_v;
            for (int i = 0; i < 10; ++i) {
                reality = (float)((double)reality + rand.nextGaussian());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            if ((double)reality < -1.5) {
                int length = EnumEnchant.badTable.length;
                reality -= (float)length * rand.nextFloat();
                if ((float)length < (reality = (float)Math.abs(Math.round(reality)))) {
                    reality = length;
                }
                EnumEnchant ee = EnumEnchant.badTable[rand.nextInt((int)reality)];
                nbt = (NBTTagCompound)ee.nbt.func_74737_b();
                this.addArticle(nbt, ee);
            } else if ((double)reality > 1.5) {
                int length = EnumEnchant.goodTable.length;
                reality += (float)length * rand.nextFloat();
                if ((float)length < (reality = (float)Math.abs(Math.round(reality)))) {
                    reality = length;
                }
                EnumEnchant ee = EnumEnchant.goodTable[rand.nextInt((int)reality)];
                nbt = (NBTTagCompound)ee.nbt.func_74737_b();
                this.addArticle(nbt, ee);
            }
            this.addName(rand, nbt);
            this.addIcon(rand, nbt);
            event.crafting.field_77990_d = nbt;
            this.spawnEntityItem((Entity)event.player, new ItemStack(Blocks.field_150380_bt));
        }
    }

    private void addIcon(Random rand, NBTTagCompound nbt) {
        nbt.func_74774_a("iconNum", (byte)rand.nextInt(7));
    }

    private void addName(Random rand, NBTTagCompound nbt) {
        String s = StatCollector.func_74838_a((String)("bambooEnch." + nameTable[rand.nextInt(nameTable.length)] + ".name")).trim();
        if (nbt.func_150297_b("display", 10)) {
            s = ((NBTTagCompound)nbt.func_74781_a("display")).func_74779_i("Name") + s;
        }
        s = s + StatCollector.func_74838_a((String)("bambooEnch." + tyoeTable[rand.nextInt(tyoeTable.length)] + ".name"));
        NBTTagCompound nameNBT = new NBTTagCompound();
        nameNBT.func_74778_a("Name", s.trim());
        nbt.func_74782_a("display", (NBTBase)nameNBT);
    }

    private void addArticle(NBTTagCompound nbt, EnumEnchant ee) {
        NBTTagCompound nameNBT = new NBTTagCompound();
        nameNBT.func_74778_a("Name", StatCollector.func_74838_a((String)("bambooEnch." + ee.name() + ".name")).trim());
        nbt.func_74782_a("display", (NBTBase)nameNBT);
    }

    private void spawnEntityItem(Entity entity, ItemStack is) {
        entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, is));
    }

    private static enum EnumEnchant {
        strange(BambooEnchantment.eat, 1),
        bad(BambooEnchantment.accele, 1),
        call(BambooEnchantment.summons, 1),
        crude(BambooEnchantment.accele, 1, Enchantment.field_77347_r, 1),
        aging(Enchantment.field_77347_r, 2),
        evil(Enchantment.field_77349_p, 1, BambooEnchantment.blood, 1),
        bloody(BambooEnchantment.blood, 2),
        chaos(BambooEnchantment.summons, 2, BambooEnchantment.teleport, 1),
        terrible(BambooEnchantment.blood, 2, BambooEnchantment.burst, 2),
        greedy(BambooEnchantment.accele, 3, BambooEnchantment.lucky, 1),
        cursed(Enchantment.field_77349_p, 3, BambooEnchantment.teleport, 2, BambooEnchantment.blood, 1),
        fallingdown(BambooEnchantment.accele, 3, BambooEnchantment.teleport, 3, BambooEnchantment.blood, 3),
        good(Enchantment.field_77349_p, 1),
        powerful(BambooEnchantment.breaker, 1),
        burst(BambooEnchantment.burst, 1),
        uncommon(Enchantment.field_77349_p, 1, Enchantment.field_77346_s, 1),
        cut(Enchantment.field_77348_q, 1),
        light(Enchantment.field_77349_p, 2),
        rare(Enchantment.field_77349_p, 2, Enchantment.field_77347_r, 1),
        epic(Enchantment.field_77349_p, 2, BambooEnchantment.breaker, 1),
        fortune(Enchantment.field_77346_s, 2, BambooEnchantment.lucky, 1),
        chain(BambooEnchantment.chain, 1),
        legendary(Enchantment.field_77349_p, 3, Enchantment.field_77347_r, 2, BambooEnchantment.chain, 1),
        mythology(Enchantment.field_77349_p, 4, Enchantment.field_77347_r, 2, BambooEnchantment.lucky, 2, BambooEnchantment.chain, 1);

        public static EnumEnchant[] badTable;
        public static EnumEnchant[] goodTable;
        private NBTTagCompound nbt = new NBTTagCompound();

        private EnumEnchant(Object ... objects) {
            this.nbt.func_74782_a("ench", (NBTBase)new NBTTagList());
            this.nbt.func_74782_a("spench", (NBTBase)new NBTTagList());
            NBTTagList enchList = this.nbt.func_150295_c("ench", 10);
            NBTTagList spenchList = this.nbt.func_150295_c("spench", 10);
            Iterator<Object> ite = Arrays.asList(objects).iterator();
            while (ite.hasNext()) {
                NBTTagCompound nbt;
                Object o = ite.next();
                if (o instanceof Enchantment) {
                    nbt = new NBTTagCompound();
                    nbt.func_74777_a("id", (short)((Enchantment)o).field_77352_x);
                    nbt.func_74777_a("lvl", ((Integer)ite.next()).shortValue());
                    enchList.func_74742_a((NBTBase)nbt);
                    continue;
                }
                nbt = new NBTTagCompound();
                nbt.func_74777_a("id", (short)((EnchantBase)o).getId());
                nbt.func_74777_a("lvl", ((Integer)ite.next()).shortValue());
                spenchList.func_74742_a((NBTBase)nbt);
            }
        }

        static {
            badTable = new EnumEnchant[]{strange, bad, call, crude, aging, evil, bloody, chaos, terrible, greedy, cursed, fallingdown};
            goodTable = new EnumEnchant[]{good, powerful, burst, uncommon, rare, cut, light, epic, fortune, chain, legendary, mythology};
        }
    }
}

