/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import ruby.bamboo.BambooInit;
import ruby.bamboo.block.BlockBambooShoot;
import ruby.bamboo.block.MaterialBamboo;
import ruby.bamboo.render.block.RenderCoordinateBlock;

public class BlockBamboo
extends Block
implements RenderCoordinateBlock.ICoordinateRenderType,
IGrowable {
    private final int MAX_BAMBOO_LENGTH;
    private final int renderType;
    private final int coordinateRenderType;

    public BlockBamboo(int maxLength, int renderType) {
        this(maxLength, renderType, 0);
    }

    public BlockBamboo(int maxLength, int renderType, int coordinateRenderType) {
        super((Material)MaterialBamboo.instance);
        this.MAX_BAMBOO_LENGTH = maxLength;
        this.renderType = renderType;
        this.coordinateRenderType = coordinateRenderType;
        BlockBambooShoot.bambooList.add(this);
        this.func_149713_g(0);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        this.tryBambooGrowth(world, i, j, k, world.func_72896_J() ? 0.25f : 0.125f);
    }

    private void tryBambooGrowth(World world, int x, int y, int z, float probability) {
        int meta;
        if (!world.field_72995_K && world.func_147437_c(x, y + 1, z) && world.field_73012_v.nextFloat() < probability && (meta = world.func_72805_g(x, y, z)) != 15) {
            if (meta < this.MAX_BAMBOO_LENGTH) {
                this.growBamboo(world, x, y, z, meta);
            } else if (world.func_72896_J() || world.field_73012_v.nextFloat() < probability) {
                this.tryChildSpawn(world, x, y, z);
            }
        }
    }

    void growBamboo(World world, int x, int y, int z, int meta) {
        world.func_147465_d(x, y + 1, z, (Block)this, meta + 1, 3);
    }

    void tryChildSpawn(World world, int i, int j, int k) {
        if (!world.field_72995_K) {
            j -= this.MAX_BAMBOO_LENGTH;
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int j1 = -1; j1 <= 1; ++j1) {
                    for (int k1 = -1; k1 <= 1; ++k1) {
                        if (!this.canChildSpawn(world, i + i1, j + j1, k + k1, world.field_73012_v)) continue;
                        world.func_147465_d(i + i1, j + j1 - 1, k + k1, Blocks.field_150346_d, 0, 3);
                        world.func_147465_d(i + i1, j + j1, k + k1, BambooInit.bambooShoot, 15, 3);
                    }
                }
            }
        }
    }

    boolean canChildSpawn(World world, int i, int j, int k, Random random) {
        if (world.func_147437_c(i, j, k)) {
            float f = random.nextFloat();
            float f2 = world.func_72896_J() ? 0.4f : (world.func_147439_a(i, j - 1, k) == Blocks.field_150458_ak ? 0.25f : 0.1f);
            if (f < f2 && (world.func_147439_a(i, j - 1, k) == Blocks.field_150346_d || world.func_147439_a(i, j - 1, k) == Blocks.field_150349_c || world.func_147439_a(i, j - 1, k) == Blocks.field_150458_ak)) {
                return true;
            }
        }
        return false;
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkBlockCoordValid(world, x, y, z);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        if (par1World.func_147439_a(par2, par3 - par6, par4) == this) {
            this.func_149642_a(par1World, par2, par3, par4, new ItemStack(BambooInit.itembamboo));
            par1World.func_147468_f(par2, par3 - par6, par4);
        }
    }

    protected final void checkBlockCoordValid(World world, int i, int j, int k) {
        if (!this.func_149718_j(world, i, j, k)) {
            this.func_149642_a(world, i, j, k, new ItemStack(BambooInit.itembamboo));
            world.func_147468_f(i, j, k);
        }
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j - 1, k);
        if (block == this) {
            return true;
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d;
    }

    public Item func_149650_a(int par1, Random rand, int par3) {
        return BambooInit.itembamboo;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public int func_149656_h() {
        return 1;
    }

    @Override
    public int getCoordinateRenderType() {
        return this.coordinateRenderType;
    }

    public boolean isToolEffective(String type, int metadata) {
        return type.equals("axe");
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(BambooInit.itembamboo);
    }

    public boolean func_149851_a(World world, int posX, int posY, int posZ, boolean isRemote) {
        return true;
    }

    public boolean func_149852_a(World world, Random rand, int posX, int posY, int posZ) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int posX, int posY, int posZ) {
        while (world.func_147439_a(posX, posY, posZ) == this) {
            ++posY;
        }
        this.tryBambooGrowth(world, posX, posY - 1, posZ, 0.75f);
    }
}

