/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.BambooUtil;
import ruby.bamboo.CustomRenderHandler;
import ruby.bamboo.entity.villager.EntityTrueVillager;
import ruby.bamboo.tileentity.TileEntityVillagerBlock;

public class BlockVillager
extends BlockContainer {
    public BlockVillager() {
        super(Material.field_151578_c);
        this.func_149711_c(0.5f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityVillagerBlock();
    }

    public boolean func_149727_a(World world, int posX, int posY, int posZ, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(posX, posY, posZ);
        if (player != null && tile != null && tile instanceof TileEntityVillagerBlock) {
            ItemStack is = player.func_71124_b(0);
            if (!world.field_72995_K) {
                if (is != null && is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150475_bE)) {
                    --is.field_77994_a;
                    ((TileEntityVillagerBlock)tile).addExp(1);
                } else if (is != null && is.func_77973_b() == Items.field_151055_y) {
                    for (ItemStack item : ((TileEntityVillagerBlock)tile).getInnerItems()) {
                        if (item == null || 0 >= item.field_77994_a) continue;
                        this.func_149642_a(world, posX, posY, posZ, item);
                    }
                } else {
                    ((IMerchant)tile).func_70932_a_(player);
                    player.func_71030_a((IMerchant)tile, "VillagerBlock");
                }
            } else if (is != null && is.func_77973_b() == Items.field_151055_y) {
                ((TileEntityVillagerBlock)tile).decrRollSpeed();
            }
            return true;
        }
        return false;
    }

    public void func_149681_a(World world, int posX, int posY, int posZ, int meta, EntityPlayer player) {
        this.func_149697_b(world, posX, posY, posZ, meta, 0);
        super.func_149681_a(world, posX, posY, posZ, meta, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int posX, int posY, int posZ, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack itemstack = new ItemStack((Block)this, 1, 0);
        TileEntityVillagerBlock tile = (TileEntityVillagerBlock)world.func_147438_o(posX, posY, posZ);
        if (tile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemstack.func_77982_d(nbt);
            tile.writeToVillagerNBT(nbt);
            ret.add(itemstack);
        }
        return ret;
    }

    public void func_149689_a(World world, int posX, int posY, int posZ, EntityLivingBase living, ItemStack itemstack) {
        if (!world.field_72995_K) {
            world.func_72921_c(posX, posY, posZ, (int)BambooUtil.getPlayerDir((Entity)living), 3);
            if (this.checkSummonFormAndRemoveBlock(world, posX, posY, posZ, Blocks.field_150425_aM)) {
                living.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(living.field_70170_p, (double)posX, (double)posY, (double)posZ));
                EntityTrueVillager entity = new EntityTrueVillager(living.field_70170_p);
                entity.func_70624_b(living);
                entity.func_70107_b(posX, posY + 10, posZ);
                living.field_70170_p.func_72838_d((Entity)entity);
            } else if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("list")) {
                if (this.checkSummonFormAndRemoveBlock(world, posX, posY, posZ, Blocks.field_150346_d)) {
                    EntityVillager entity = new EntityVillager(world);
                    NBTTagCompound nbt = new NBTTagCompound();
                    entity.func_70014_b(nbt);
                    nbt.func_74782_a("Offers", itemstack.func_77978_p().func_74781_a("list"));
                    entity.func_70020_e(nbt);
                    entity.func_70107_b((double)posX, (double)posY, (double)posZ);
                    world.func_72838_d((Entity)entity);
                } else {
                    TileEntity tile = world.func_147438_o(posX, posY, posZ);
                    if (tile instanceof TileEntityVillagerBlock) {
                        ((TileEntityVillagerBlock)tile).readFromVillagerNBT(itemstack.func_77978_p());
                    }
                }
            }
        }
    }

    public boolean checkSummonFormAndRemoveBlock(World world, int posX, int posY, int posZ, Block blockType) {
        if (world.func_147439_a(posX, posY - 1, posZ) == blockType) {
            ForgeDirection[] dir;
            for (ForgeDirection fd : dir = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH}) {
                if (world.func_147439_a(posX + fd.offsetX, posY - 1, posZ + fd.offsetZ) != blockType || world.func_147439_a(posX + fd.getOpposite().offsetX, posY - 1, posZ + fd.getOpposite().offsetZ) != blockType || world.func_147439_a(posX, posY - 2, posZ) != blockType) continue;
                world.func_147468_f(posX, posY, posZ);
                world.func_147468_f(posX, posY - 1, posZ);
                world.func_147468_f(posX, posY - 2, posZ);
                world.func_147468_f(posX + fd.offsetX, posY - 1, posZ + fd.offsetZ);
                world.func_147468_f(posX + fd.getOpposite().offsetX, posY - 1, posZ + fd.getOpposite().offsetZ);
                return true;
            }
        }
        return false;
    }

    public int func_149645_b() {
        return CustomRenderHandler.villagerBlockUID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return Blocks.field_150425_aM.func_149733_h(p_149691_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int posX, int posY, int posZ, Random rand) {
        if ((world.func_72805_g(posX, posY, posZ) & 4) != 0) {
            this.generateRandomParticles(world, "heart", posX, posY, posZ);
        }
    }

    private void generateRandomParticles(World worldObj, String particlesName, int xCoord, int yCoord, int zCoord) {
        for (int i = 0; i < 5; ++i) {
            double d0 = worldObj.field_73012_v.nextGaussian() * 0.02;
            double d1 = worldObj.field_73012_v.nextGaussian() * 0.02;
            double d2 = worldObj.field_73012_v.nextGaussian() * 0.02;
            worldObj.func_72869_a(particlesName, (double)xCoord + (double)(worldObj.field_73012_v.nextFloat() * 2.0f) - 0.5, (double)yCoord + 1.0 + (double)worldObj.field_73012_v.nextFloat(), (double)zCoord + (double)(worldObj.field_73012_v.nextFloat() * 2.0f) - 0.5, d0, d1, d2);
        }
    }
}

