/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class TileEntityVillagerBlock
extends TileEntity
implements IMerchant,
ISidedInventory {
    private ItemStack[] innerInv = new ItemStack[2];
    private MerchantRecipeList recipeList;
    private int merchantType;
    private EntityPlayer customer;
    private byte exp;
    private int coolTime;
    private float offsetRoteY = 0.0f;
    public static final int MAX_COOL_TIME = 60;
    private int roteSpeed = 60;

    public int getMerchantType() {
        return this.merchantType;
    }

    public void setMerchantType(int type) {
        this.merchantType = type;
    }

    public void addExp(int exp) {
        this.exp = (byte)(this.exp + exp);
        if (Integer.bitCount(this.exp) == 1) {
            this.addVanillaVillagerTrade();
            this.addEmotion(1);
            this.coolTime = 20;
            if (128 <= this.exp) {
                this.exp = (byte)64;
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeToVillagerNBT(nbt);
    }

    public void writeToVillagerNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("exp", this.exp);
        nbt.func_74768_a("merchantType", this.merchantType);
        if (this.recipeList == null) {
            this.setDefaultList();
        }
        nbt.func_74782_a("list", (NBTBase)this.recipeList.func_77202_a());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromVillagerNBT(nbt);
    }

    public void readFromVillagerNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("exp")) {
            this.exp = nbt.func_74771_c("exp");
        }
        if (nbt.func_74764_b("merchantType")) {
            this.merchantType = nbt.func_74762_e("merchantType");
        }
        if (nbt.func_74764_b("list")) {
            this.recipeList = new MerchantRecipeList(nbt.func_74775_l("list"));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.recipeList == null) {
            this.setDefaultList();
        }
        return this.recipeList;
    }

    private void setDefaultList() {
        this.addVanillaVillagerTrade();
    }

    public MerchantRecipe createMerchantRecipeInstance(Item item, Random rand) {
        return new MerchantRecipe(this.createItemStack(item, rand), Items.field_151166_bC);
    }

    private ItemStack createItemStack(Item item, Random rand) {
        return new ItemStack(item, this.getRandomStackSize(item, rand), 0);
    }

    private int getRandomStackSize(Item item, Random rand) {
        Tuple tuple = (Tuple)EntityVillager.field_70958_bB.get(item);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + rand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    public void func_70930_a(MerchantRecipeList list) {
        this.recipeList = list;
    }

    public void func_70933_a(MerchantRecipe list) {
        list.func_77399_f();
        this.func_145831_w().func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "mob.villager.yes", 1.0f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    public void func_110297_a_(ItemStack itemStack) {
    }

    public void addVanillaVillagerTrade() {
        EntityVillager dummyVillger = new EntityVillager(this.field_145850_b);
        dummyVillger.func_70938_b(this.merchantType);
        if (this.recipeList == null) {
            this.recipeList = dummyVillger.func_70934_b(this.customer);
        } else {
            this.recipeList.func_77205_a((MerchantRecipe)dummyVillger.func_70934_b(this.customer).get(0));
        }
        dummyVillger.func_70106_y();
        this.func_70296_d();
    }

    public void func_145845_h() {
        if (!this.func_145831_w().field_72995_K) {
            MerchantRecipe recipe;
            if (this.coolTime < 1 && this.innerInv[0] != null && this.innerInv[1] == null && this.recipeList != null && (recipe = this.recipeList.func_77203_a(this.innerInv[0], null, 0)) != null && this.innerInv[1] == null) {
                this.innerInv[0].field_77994_a -= recipe.func_77394_a().field_77994_a;
                this.innerInv[1] = recipe.func_77397_d().func_77946_l();
                this.addEmotion(3);
                this.coolTime = 60;
            }
        } else {
            this.offsetRoteY = (this.func_145832_p() & 8) != 0 ? (this.offsetRoteY < 359.0f ? this.offsetRoteY + 360.0f / (float)this.roteSpeed : 0.0f) : 0.0f;
        }
        if (this.coolTime == 1) {
            this.removeEmotion();
            --this.coolTime;
        } else if (1 < this.coolTime) {
            --this.coolTime;
        }
    }

    public void addEmotion(int emNum) {
        if (!this.func_145831_w().field_72995_K) {
            int meta = this.func_145832_p();
            this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta |= (emNum & 3) << 2, 3);
        }
    }

    public void removeEmotion() {
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 3, 3);
        }
        this.roteSpeed = 60;
    }

    public boolean isEmoted() {
        return (this.func_145832_p() & 0xC) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getOffsetRoteY() {
        return this.offsetRoteY;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this.innerInv[slot];
    }

    public ItemStack func_70298_a(int slot, int dec) {
        if (this.innerInv[slot] != null) {
            if (this.innerInv[slot].field_77994_a <= dec) {
                ItemStack itemstack = this.innerInv[slot];
                this.innerInv[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.innerInv[slot].func_77979_a(dec);
            if (this.innerInv[slot].field_77994_a == 0) {
                this.innerInv[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.innerInv[slot] != null) {
            ItemStack itemstack = this.innerInv[slot];
            this.innerInv[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        this.innerInv[slot] = is;
    }

    public String func_145825_b() {
        return "VillagerBlockInnner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int side, ItemStack is) {
        return side == 0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{side == 1 ? 0 : (side == 0 ? 1 : 0)};
    }

    public boolean func_102007_a(int slot, ItemStack is, int num) {
        return this.innerInv[0] == null || is.func_77969_a(this.innerInv[0]) && this.innerInv[0].field_77994_a + is.field_77994_a <= this.innerInv[0].func_77976_d();
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return this.innerInv[1] != null;
    }

    public void decrRollSpeed() {
        if (5 < this.roteSpeed) {
            this.roteSpeed -= 2;
            if (this.roteSpeed <= 5) {
                this.roteSpeed = 5;
            }
        }
        this.coolTime = 60;
    }

    public ArrayList<ItemStack> getInnerItems() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        for (int i = 0; i < this.innerInv.length; ++i) {
            res.add(this.innerInv[i]);
            this.innerInv[i] = null;
        }
        this.addEmotion(2);
        this.coolTime = 60;
        return res;
    }
}

