/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.core.init;

import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ruby.bamboo.core.DataManager;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.ClassFinder;
import ruby.bamboo.core.init.EnumCreateTab;

public class DataLoader
extends ClassFinder {
    public void init(String packagePath) {
        try {
            for (Class<?> entry : this.search(packagePath)) {
                if (entry.isAnnotationPresent(BambooData.BambooBlock.class)) {
                    this.registBlock(entry);
                    continue;
                }
                if (!entry.isAnnotationPresent(BambooData.BambooItem.class)) continue;
                this.registItem(entry);
            }
        }
        catch (Exception e) {
            FMLLog.bigWarning((String)"\u30d6\u30ed\u30c3\u30af\u521d\u671f\u5316\u4f8b\u5916", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private void registBlock(Class<? extends Block> cls) {
        try {
            String name;
            Class<?> c = Class.forName(cls.getName());
            Block instance = null;
            try {
                Constructor<?> cnst = c.getConstructor(Material.class);
                instance = (Block)cnst.newInstance(c.getAnnotation(BambooData.BambooBlock.class).material().MATERIAL);
            }
            catch (NoSuchMethodException e) {
                instance = (Block)c.newInstance();
            }
            BambooData.BambooBlock anoData = cls.getAnnotation(BambooData.BambooBlock.class);
            String string = name = anoData.name().isEmpty() ? cls.getSimpleName().toLowerCase() : anoData.name().toLowerCase();
            if (anoData.createiveTabs() != EnumCreateTab.NONE) {
                instance.func_149647_a(anoData.createiveTabs().getTabInstance());
            }
            instance.func_149663_c(name);
            GameRegistry.registerBlock((Block)instance, anoData.itemBlock(), (String)name);
            FMLLog.info((String)"BLOCK: %s to Registed", (Object[])new Object[]{name});
            DataManager.addMap(cls, name);
        }
        catch (Exception e) {
            FMLLog.warning((String)("\u30d6\u30ed\u30c3\u30af\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u767b\u9332\u4f8b\u5916:" + cls.getName()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private void registItem(Class<? extends Item> cls) {
        try {
            String name;
            Class<?> c = Class.forName(cls.getName());
            Item instance = (Item)c.newInstance();
            BambooData.BambooItem anoData = cls.getAnnotation(BambooData.BambooItem.class);
            String string = name = anoData.name().isEmpty() ? cls.getSimpleName().toLowerCase() : anoData.name().toLowerCase();
            if (anoData.createiveTabs() != EnumCreateTab.NONE) {
                instance.func_77637_a(anoData.createiveTabs().getTabInstance());
            }
            instance.func_77655_b(name);
            GameRegistry.registerItem((Item)instance, (String)name);
            FMLLog.info((String)"ITEM: %s to Registed", (Object[])new Object[]{name});
            DataManager.addMap(cls, name);
        }
        catch (Exception e) {
            FMLLog.warning((String)("\u30a2\u30a4\u30c6\u30e0\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u767b\u9332\u4f8b\u5916:" + cls.getName()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }
}

