/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.crafting;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import ruby.bamboo.block.Bamboo;
import ruby.bamboo.block.JPChest;
import ruby.bamboo.block.Kitunebi;
import ruby.bamboo.block.SakuraLog;
import ruby.bamboo.block.SakuraPlank;
import ruby.bamboo.block.Tatami;
import ruby.bamboo.block.decoration.EnumDecoration;
import ruby.bamboo.core.DataManager;
import ruby.bamboo.entity.EnumSlideDoor;
import ruby.bamboo.item.BambooBow;
import ruby.bamboo.item.FoldingFan;
import ruby.bamboo.item.ItemSlideDoor;
import ruby.bamboo.item.RiceSeed;
import ruby.bamboo.item.Sack;
import ruby.bamboo.item.Straw;
import ruby.bamboo.item.Tudura;
import ruby.bamboo.item.arrow.AntiArrow;
import ruby.bamboo.item.arrow.BambooArrow;
import ruby.bamboo.item.arrow.ExplodeArrow;
import ruby.bamboo.item.arrow.LightArrow;
import ruby.bamboo.item.arrow.TorchArrow;

public class BambooRecipes {
    private int WILD = Short.MAX_VALUE;
    private String bamboo = "bamboo";
    private String tudura = "tudura";
    private String straw = "straw";

    public void oreDicRegist() {
        OreDictionary.registerOre((String)"logWood", (ItemStack)this.getIS(SakuraLog.class));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)this.getIS(SakuraPlank.class));
        OreDictionary.registerOre((String)this.bamboo, (ItemStack)this.getIS(Bamboo.class));
        OreDictionary.registerOre((String)this.tudura, (ItemStack)this.getIS(Tudura.class));
        OreDictionary.registerOre((String)this.straw, (ItemStack)this.getIS(Straw.class));
    }

    public void craftingTableRecipes() {
        this.addShapelessRecipe(this.getIS(SakuraPlank.class, 4, 0), this.getIS(SakuraLog.class, 1, this.WILD));
        this.addShapelessRecipe(this.getIS(Sack.class), this.getIS(Sack.class, 1, this.WILD));
        this.addRecipe(this.getIS(Tudura.class), " B ", "B B", " B ", Character.valueOf('B'), this.bamboo);
        this.addRecipe(this.getIS(FoldingFan.class), "PPB", "PPB", "BBB", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('B'), this.bamboo);
        this.addRecipe(this.getIS(Sack.class), "SSS", "WTW", "WWW", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), this.tudura, Character.valueOf('W'), this.getIS(Blocks.field_150325_L, 1, this.WILD));
        this.addCircleRecipe(this.getIS(JPChest.class), this.tudura, "logWood");
        this.addRecipe(this.getIS(Tatami.class), " S ", "STS", " S ", Character.valueOf('S'), this.straw, Character.valueOf('T'), this.tudura);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.HUSUMA.getId()), "XYX", "X#X", "XYX", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF, Character.valueOf('#'), this.tudura);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.SHOZI.getId()), "XYX", "Y#Y", "XYX", Character.valueOf('#'), this.tudura, Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.GLASS.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), this.tudura, Character.valueOf('X'), Blocks.field_150411_aY, Character.valueOf('Y'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.GGLASS.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), this.tudura, Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.YUKI.getId()), "XYX", "X#X", "XZX", Character.valueOf('#'), this.tudura, Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF, Character.valueOf('Z'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(ItemSlideDoor.class, 2, EnumSlideDoor.AMADO.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), this.tudura, Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), "plankWood");
        this.addRecipe(this.getIS(Kitunebi.class, 6, 0), "XXX", "Y#Y", "XXX", Character.valueOf('X'), "gemLapis", Character.valueOf('Y'), this.tudura, Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(Kitunebi.class, 6, 0), "XXX", "Y#Y", "XXX", Character.valueOf('X'), Items.field_151079_bi, Character.valueOf('Y'), this.tudura, Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(Kitunebi.class, 6, 0), "XYX", "X#X", "XYX", Character.valueOf('X'), "gemLapis", Character.valueOf('Y'), this.tudura, Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(Kitunebi.class, 6, 0), "XYX", "X#X", "XYX", Character.valueOf('X'), Items.field_151079_bi, Character.valueOf('Y'), this.tudura, Character.valueOf('#'), Blocks.field_150428_aP);
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.KAWARA.getModName(), 8, 0), this.tudura, Items.field_151118_aC);
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.PLASTER.getModName(), 8, 0), this.tudura, Blocks.field_150354_m);
        this.addAltCircleRecipe(this.getBlockIS(EnumDecoration.NAMAKO.getModName(), 8, 0), this.tudura, this.getBlockIS(EnumDecoration.PLASTER.getModName()), this.getBlockIS(EnumDecoration.KAWARA.getModName()));
        this.addRecipe(this.getBlockIS(EnumDecoration.WARA.getModName(), 4, 0), "XXX", "XXX", "XXX", Character.valueOf('X'), this.getIS(Straw.class));
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.KAYA.getModName(), 8, 0), this.tudura, "cropWheat");
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.CBIRCH.getModName(), 8, 0), this.tudura, new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.COAK.getModName(), 8, 0), this.tudura, new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
        this.addCircleRecipe(this.getBlockIS(EnumDecoration.CPINE.getModName(), 8, 0), this.tudura, new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
        this.registerDeco();
        this.addRecipe(this.getIS(BambooBow.class), " BS", "T S", " BS", Character.valueOf('B'), this.bamboo, Character.valueOf('T'), this.tudura, Character.valueOf('S'), Items.field_151007_F);
        this.addRecipe(this.getIS(BambooArrow.class, 8, 0), "B", "T", "T", Character.valueOf('B'), this.bamboo, Character.valueOf('T'), this.tudura);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.UNDEAD, 4, Items.field_151078_bh);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.MUTANT, 8, Items.field_151016_H);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.ENDERMAN, 8, Items.field_151079_bi);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.FLAME, 8, Items.field_151145_ak);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.AIR, 8, Items.field_151008_G);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.MULTILEG, 8, Items.field_151007_F);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.HUMAN, 8, Items.field_151166_bC);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.NONLEG, 8, Items.field_151072_bj);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.HARD, 16, Items.field_151042_j);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.SOFT, 8, Items.field_151123_aH);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.WATER, 8, Items.field_151115_aP);
        this.addShapelessRecipe(this.getIS(TorchArrow.class), this.getIS(BambooArrow.class), Blocks.field_150478_aa);
        this.addShapelessRecipe(this.getIS(LightArrow.class), this.getIS(BambooArrow.class), Items.field_151008_G);
        this.addShapelessRecipe(this.getIS(ExplodeArrow.class), this.getIS(BambooArrow.class), Items.field_151016_H);
    }

    private void addAntiArrowsRecipe(AntiArrow.AntiType type, int ammo, Object material) {
        this.addRecipe(this.getIS(AntiArrow.class, ammo, (int)type.getID()), " B ", " T ", "MTM", Character.valueOf('B'), this.bamboo, Character.valueOf('T'), this.tudura, Character.valueOf('M'), material);
    }

    private void registerDeco() {
        for (EnumDecoration deco : EnumDecoration.values()) {
            if (deco.isHalf()) {
                this.addSlabRecipe(this.getBlockIS(deco.getModName() + "_slab", 6, 0), this.getBlockIS(deco.getModName(), 1, 0));
            }
            if (!deco.isStair()) continue;
            this.addStairsRecipe(this.getBlockIS(deco.getModName() + "_stairs", 4, 0), this.getBlockIS(deco.getModName(), 1, 0));
        }
    }

    public void smeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)this.getIS(SakuraLog.class), (ItemStack)this.getIS(Items.field_151044_h, 1, 1), (float)0.2f);
    }

    public void registFuel() {
        IFuelHandler handler = new IFuelHandler(){
            private Item sakuraLog = Item.func_150898_a((Block)DataManager.getBlock(SakuraLog.class));

            public int getBurnTime(ItemStack fuel) {
                if (fuel.func_77973_b() == this.sakuraLog) {
                    return 270;
                }
                return 0;
            }
        };
        GameRegistry.registerFuelHandler((IFuelHandler)handler);
    }

    public void registSeed() {
        MinecraftForge.addGrassSeed((ItemStack)this.getIS(RiceSeed.class), (int)10);
    }

    private void addCircleRecipe(ItemStack out, Object center, Object outer) {
        this.addRecipe(out, "XXX", "X#X", "XXX", Character.valueOf('#'), center, Character.valueOf('X'), outer);
    }

    private void addAltCircleRecipe(ItemStack out, Object center, Object one, Object two) {
        this.addRecipe(out, "XYX", "Y#Y", "XYX", Character.valueOf('#'), center, Character.valueOf('X'), one, Character.valueOf('Y'), two);
    }

    private void addSlabRecipe(ItemStack out, ItemStack itemStack) {
        this.addRecipe(out, "XXX", Character.valueOf('X'), itemStack);
        this.addRecipe(new ItemStack(itemStack.func_77973_b(), 1, 0), "X", "X", Character.valueOf('X'), out);
    }

    private void addStairsRecipe(ItemStack out, Object material) {
        this.addRecipe(out, "X  ", "XX ", "XXX", Character.valueOf('X'), material);
        this.addRecipe(out, "  X", " XX", "XXX", Character.valueOf('X'), material);
    }

    private void addRecipe(ItemStack output, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, params));
    }

    private void addShapelessRecipe(Object ... objArray) {
        Object[] params = new Object[objArray.length - 1];
        ItemStack output = objArray[0] instanceof Class ? this.getIS((Class)objArray[0]) : (ItemStack)objArray[0];
        for (int i = 1; i < objArray.length; ++i) {
            params[i - 1] = objArray[i] instanceof Class ? this.getIS((Class)objArray[i]) : objArray[i];
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, params));
    }

    private ItemStack getIS(Block block) {
        return this.getIS(block, 0);
    }

    private ItemStack getIS(Block block, int meta) {
        return this.getIS(block, 1, meta);
    }

    private ItemStack getIS(Block block, int amo, int meta) {
        return new ItemStack(block, amo, meta);
    }

    private ItemStack getIS(Item item) {
        return this.getIS(item, 0);
    }

    private ItemStack getIS(Item item, int meta) {
        return this.getIS(item, 1, meta);
    }

    private ItemStack getIS(Item item, int amo, int meta) {
        return new ItemStack(item, amo, meta);
    }

    private ItemStack getIS(Class cls) {
        return this.getIS(cls, 0);
    }

    private ItemStack getIS(Class cls, int meta) {
        return this.getIS(cls, 1, meta);
    }

    private ItemStack getIS(Class cls, int amo, int meta) {
        ItemStack is = null;
        is = Block.class.isAssignableFrom(cls) ? new ItemStack(DataManager.getBlock(cls), amo, meta) : new ItemStack(DataManager.getItem(cls), amo, meta);
        if (is.func_77973_b() == null) {
            throw new IllegalArgumentException("Illegal recipe!" + cls.getSimpleName());
        }
        return is;
    }

    private ItemStack getBlockIS(String name) {
        return this.getBlockIS(name, 1, 0);
    }

    private ItemStack getBlockIS(String name, int amo, int meta) {
        return new ItemStack(Block.func_149684_b((String)name), amo, meta);
    }

    private ItemStack getItemIS(String name, int amo, int meta) {
        return new ItemStack(Item.func_111206_d((String)name), amo, meta);
    }
}

