/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SakuraPetal
extends Entity {
    float rx;
    float ry;
    float rz;
    boolean xflg = true;
    boolean yflg = true;
    boolean zflg = true;
    boolean stopFall = false;
    String texPath;
    int texNum;
    float particleRed;
    float particleGreen;
    float particleBlue;
    float rad = (float)((double)this.rad + 0.025 * (double)this.field_70146_Z.nextFloat());
    int particleAge;
    int particleMaxAge;

    public SakuraPetal(World world) {
        super(world);
        this.func_70105_a(0.2f, 0.2f);
        this.field_70159_w = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1;
        this.field_70181_x = -0.01;
        this.field_70179_y = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1;
        this.particleAge = 0;
        this.particleMaxAge = this.field_70146_Z.nextInt(120) + 60;
        this.rx = world.field_73012_v.nextFloat();
        this.ry = world.field_73012_v.nextFloat();
        this.rz = world.field_73012_v.nextFloat();
        this.texPath = "bamboomod:textures/entitys/petal.png";
    }

    public void setPosition(BlockPos pos) {
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void setColor(int color) {
        this.particleRed = (float)(color >> 16) / 255.0f;
        this.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        this.particleBlue = (float)(color & 0xFF) / 255.0f;
    }

    public void setTexNum(int num) {
        this.texNum = num;
    }

    public void setTexPath(String path) {
        this.texPath = path;
    }

    public String getTexPath() {
        return this.texPath;
    }

    public int getTexNum() {
        return this.texNum;
    }

    public float getRx() {
        this.rx += this.xflg ? this.rad : -this.rad;
        this.xflg = !(!this.xflg ? this.rx > -1.0f : this.rx > 1.0f);
        return this.rx;
    }

    public float getRy() {
        this.ry += this.yflg ? this.rad : -this.rad;
        this.yflg = !(!this.yflg ? this.ry > -1.0f : this.ry > 1.0f);
        return this.ry;
    }

    public float getRz() {
        this.rz += this.zflg ? this.rad : -this.rad;
        this.zflg = !(!this.zflg ? this.rz > -1.0f : this.rz > 1.0f);
        return this.rz;
    }

    public float getRedColorF() {
        return this.particleRed;
    }

    public float getGreenColorF() {
        return this.particleGreen;
    }

    public float getBlueColorF() {
        return this.particleBlue;
    }

    public void setCustomPetal(IBlockState state) {
        this.texPath = ((ICustomPetal)state.func_177230_c()).getTexPath(state);
        this.texNum = ((ICustomPetal)state.func_177230_c()).getTexNum(state);
    }

    public void setMotion(double mx, double my, double mz) {
        float randomF = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float sq = MathHelper.func_76133_a((double)(mx * mx + my * my + mz * mz));
        this.field_70159_w = mx / (double)sq * (double)randomF;
        this.field_70181_x = my / (double)sq;
        this.field_70179_y = mz / (double)sq * (double)randomF;
    }

    public void setStopFall() {
        this.stopFall = true;
        this.particleAge = 0;
        this.rad = 0.002f;
        this.field_70179_y = 0.0;
        this.field_70159_w = 0.0;
    }

    public boolean isStopFall() {
        return this.stopFall;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.func_70106_y();
        }
        if (!this.stopFall) {
            this.field_70181_x -= 0.004;
        } else if (this.field_70181_x != 0.0) {
            this.field_70181_x /= 1.2;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70072_I();
        this.field_70159_w *= 0.95;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.95;
        if (this.func_70090_H() && !this.isStopFall()) {
            this.setStopFall();
        }
        if (this.field_70122_E) {
            this.rad = 1.0E-4f;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
    }

    public static interface ICustomPetal {
        public int getTexNum(IBlockState var1);

        public String getTexPath(IBlockState var1);
    }
}

