/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.DataManager;
import ruby.bamboo.entity.EnumSlideDoor;
import ruby.bamboo.item.ItemSlideDoor;

public class SlideDoor
extends Entity {
    private byte closeTimer;
    private static final byte DIRECTION = 17;
    private static final byte ISMIRROR = 18;
    private static final byte ISMOVE = 19;
    private static final byte DOORID = 20;
    private static final byte ISSTOP = 22;
    private static final byte MOVEDIR = 23;
    private static EnumSlideDoor[] tex = EnumSlideDoor.values();

    public SlideDoor(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isBlend() ? pass == 1 : pass == 0;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (par1EntityPlayer.func_70093_af()) {
            this.setDataisStop(!this.getDataIsStop());
            par1EntityPlayer.func_71038_i();
            return true;
        }
        if (this.getDataIsStop()) {
            if (!this.getDataMoveflg()) {
                this.doorOpen((Entity)par1EntityPlayer);
            } else {
                this.doorClose();
            }
            par1EntityPlayer.func_71038_i();
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
    }

    public void func_70108_f(Entity entityIn) {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public String getTex() {
        return this.getEnumSlideDoor(this.getDataDoorId()).getTex();
    }

    public void setMirror(boolean b) {
        this.setDataMirror(b);
    }

    public boolean isMirror() {
        return this.getDataMirror();
    }

    public EnumFacing getDir() {
        return this.getDataDir();
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setDataDir(nbttagcompound.func_74771_c("dir"));
        this.setDataMirror(nbttagcompound.func_74767_n("mirror"));
        this.setDataMoveflg(nbttagcompound.func_74767_n("moveflg"));
        this.setDataisStop(nbttagcompound.func_74767_n("isStop"));
        if (nbttagcompound.func_74764_b("doorId")) {
            this.setDataDoorId(nbttagcompound.func_74765_d("doorId"));
        } else if (nbttagcompound.func_74779_i("toptex").indexOf("husuma") != -1) {
            this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        } else {
            this.setDataDoorId(EnumSlideDoor.SHOZI.getId());
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("dir", (byte)this.getDataDir().func_176736_b());
        nbttagcompound.func_74757_a("mirror", this.getDataMirror());
        nbttagcompound.func_74757_a("moveflg", this.getDataMoveflg());
        nbttagcompound.func_74757_a("isStop", this.getDataIsStop());
        nbttagcompound.func_74774_a("doorId", this.getDataDoorId());
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!(this.field_70170_p.field_72995_K || this.getDataIsStop() || this.field_70128_L)) {
            EntityPlayer entityplayer = null;
            if (par1DamageSource.field_76373_n != "player") {
                return false;
            }
            entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            this.func_70106_y();
            if (entityplayer != null && entityplayer.field_71075_bZ.field_75098_d) {
                return true;
            }
            this.dropItem(this.getDataDoorId());
        }
        if (this.getDataIsStop() && par1DamageSource.func_76346_g() != null) {
            double offsetPosX = this.field_70165_t;
            double offsetPosZ = this.field_70161_v;
            switch (par1DamageSource.func_76346_g().func_174811_aO()) {
                case EAST: {
                    offsetPosX += 0.05;
                    break;
                }
                case NORTH: {
                    offsetPosZ -= 0.05;
                    break;
                }
                case SOUTH: {
                    offsetPosZ += 0.05;
                    break;
                }
                case WEST: {
                    offsetPosX -= 0.05;
                    break;
                }
                case UP: {
                    break;
                }
                case DOWN: {
                    break;
                }
            }
            this.func_70107_b(offsetPosX, this.field_70163_u, offsetPosZ);
        }
        return true;
    }

    private void dropItem(short damage) {
        this.func_70099_a(new ItemStack((Item)DataManager.getItem(ItemSlideDoor.class), 1, (int)damage), 1.0f);
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.getDataIsStop() && !this.getDataMoveflg()) {
            this.doorOpen((Entity)par1EntityPlayer);
        }
        this.closeTimer = (byte)10;
    }

    public void func_70071_h_() {
        List collideEntity;
        if (!this.field_70170_p.field_72995_K && (collideEntity = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) != null) {
            for (Entity entity : collideEntity) {
                if (entity.field_70128_L || !(entity instanceof EntityTameable)) continue;
                if (!this.getDataIsStop() && !this.getDataMoveflg()) {
                    this.doorOpen(entity);
                }
                this.closeTimer = (byte)30;
            }
        }
        this.field_70145_X = true;
        if (!this.getDataIsStop()) {
            if (this.closeTimer < 0 && this.getDataMoveflg()) {
                this.doorClose();
            } else {
                this.closeTimer = (byte)(this.closeTimer - 1);
            }
        }
    }

    private void doorOpen(Entity entity) {
        if (!this.getDataMoveflg() && this.isOpendir(entity)) {
            EnumFacing facing = this.getDir();
            if (this.getDataMirror()) {
                facing = facing.func_176734_d();
            }
            switch (facing.func_176740_k()) {
                case X: {
                    this.field_70161_v -= (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, (double)(-facing.func_176743_c().func_179524_a())));
                    break;
                }
                case Z: {
                    this.field_70165_t += (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d((double)facing.func_176743_c().func_179524_a(), 0.0, 0.0));
                    break;
                }
            }
            this.setDataMoveflg(true);
        }
    }

    private void doorClose() {
        if (this.getDataMoveflg()) {
            EnumFacing facing = this.getDir();
            if (this.getDataMirror()) {
                facing = facing.func_176734_d();
            }
            switch (facing.func_176740_k()) {
                case X: {
                    this.field_70161_v += (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, (double)facing.func_176743_c().func_179524_a()));
                    break;
                }
                case Z: {
                    this.field_70165_t -= (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d((double)(-facing.func_176743_c().func_179524_a()), 0.0, 0.0));
                    break;
                }
            }
            this.setDataMoveflg(false);
        }
    }

    private boolean isOpendir(Entity entity) {
        if (entity.func_174811_aO() != this.getDir() && entity.func_174811_aO() != this.getDir().func_176734_d()) {
            return false;
        }
        return this.func_70032_d(entity) < 1.25f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    private EnumFacing getDataDir() {
        return EnumFacing.func_176731_b((int)this.field_70180_af.func_75683_a(17));
    }

    private boolean getDataMirror() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    private boolean getDataMoveflg() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    private byte getDataMovedir() {
        return this.field_70180_af.func_75683_a(23);
    }

    private boolean getDataIsStop() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    private byte getDataDoorId() {
        return this.field_70180_af.func_75683_a(20);
    }

    public SlideDoor setDataDir(byte b) {
        this.field_70180_af.func_75692_b(17, (Object)b);
        return this;
    }

    public void setDataMirror(boolean flg) {
        this.field_70180_af.func_75692_b(18, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMoveflg(boolean flg) {
        this.field_70180_af.func_75692_b(19, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMovedir(byte dir) {
        this.field_70180_af.func_75692_b(23, (Object)dir);
    }

    public SlideDoor setDataisStop(boolean flg) {
        this.field_70180_af.func_75692_b(22, (Object)(flg ? (byte)1 : 0));
        return this;
    }

    public SlideDoor setDataDoorId(int id) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)id));
        return this;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean isBlend() {
        return this.getEnumSlideDoor(this.getDataDoorId()).isBlend();
    }

    private EnumSlideDoor getEnumSlideDoor(int id) {
        if (id < tex.length) {
            return tex[id];
        }
        this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        return EnumSlideDoor.HUSUMA;
    }
}

