/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity.arrow;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import ruby.bamboo.core.DataManager;
import ruby.bamboo.entity.arrow.BaseArrow;
import ruby.bamboo.item.arrow.AntiArrow;

public class EntityAntiArrow
extends BaseArrow {
    public EntityAntiArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityAntiArrow(World worldIn, EntityLivingBase shooter, EntityLivingBase p_i1755_3_, float p_i1755_4_, float p_i1755_5_) {
        super(worldIn, shooter, p_i1755_3_, p_i1755_4_, p_i1755_5_);
    }

    public EntityAntiArrow(World worldIn, EntityLivingBase shooter, float velocity) {
        super(worldIn, shooter, velocity);
    }

    public EntityAntiArrow(World worldIn) {
        super(worldIn);
    }

    public EntityAntiArrow(World worldIn, EntityLivingBase shooter, float velocity, ItemStack is) {
        super(worldIn, shooter, velocity, is);
        this.setArrowType(AntiArrow.AntiType.getType(is.func_77952_i()));
    }

    public void setArrowType(AntiArrow.AntiType type) {
        this.field_70180_af.func_75692_b(17, (Object)type.getID());
    }

    public AntiArrow.AntiType getArrowType() {
        return AntiArrow.AntiType.getType(this.field_70180_af.func_75683_a(17));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    @Override
    public int getArrowDamage(Entity entity) {
        int damage = super.getArrowDamage(entity);
        for (Class<? extends Entity> clazz : this.getArrowType().getEntity()) {
            if (!clazz.isInstance(entity)) continue;
            damage = (int)((double)damage * (1.0 + 1.5 / (double)this.getArrowType().getEntity().length));
            break;
        }
        return damage;
    }

    @Override
    public DamageSource getDamageSource(EntityArrow arrow, Entity entity) {
        if (this.getArrowType() != AntiArrow.AntiType.ENDERMAN) {
            return DamageSource.func_76353_a((EntityArrow)arrow, (Entity)entity);
        }
        return new EntityDamageSource("antiEnder", entity);
    }

    @Override
    public boolean onEntityDamaged(Entity entityHit) {
        if (this.getArrowType() != AntiArrow.AntiType.ENDERMAN) {
            return true;
        }
        this.func_70106_y();
        return false;
    }

    @Override
    public void motionUpdate(float xyzVariation, float yDecrease) {
        if (this.getArrowType() == AntiArrow.AntiType.WATER) {
            xyzVariation = 0.99f;
        }
        this.field_70159_w *= (double)xyzVariation;
        this.field_70181_x *= (double)xyzVariation;
        this.field_70179_y *= (double)xyzVariation;
        this.field_70181_x -= (double)yDecrease * 0.5;
    }

    @Override
    public void spawnCritParticle() {
        for (int k = 0; k < 4; ++k) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, 0.0, -0.025, 0.0, new int[0]);
        }
    }

    @Override
    public ItemStack getItemArrow() {
        return DataManager.getItemStack(AntiArrow.class, 1, this.getArrowType().getID());
    }

    @Override
    public NBTTagCompound writeCustomNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("id", this.getArrowType().getID());
        return nbt;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("id")) {
            this.setArrowType(AntiArrow.AntiType.getType(nbt.func_74771_c("id")));
        }
    }
}

