/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.generate;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import ruby.bamboo.block.BambooShoot;
import ruby.bamboo.block.SakuraSapling;
import ruby.bamboo.core.DataManager;

public class GenerateHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        WorldChunkManager worldchunkmanager = world.func_72959_q();
        if (worldchunkmanager != null) {
            BiomeGenBase biome = worldchunkmanager.func_180631_a(new BlockPos(chunkX * 16, 64, chunkZ * 16));
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                    switch (random.nextInt(4)) {
                        case 1: {
                            this.generateBambooshoot(random, world, chunkX, chunkZ, 60);
                            break;
                        }
                        case 2: {
                            this.generateSakura(random, world, chunkX, chunkZ, 90);
                        }
                    }
                }
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                switch (random.nextInt(4)) {
                    default: 
                }
            }
        }
    }

    private void generateBambooshoot(Random random, World world, int chunkX, int chunkZ, int maxHeight) {
        for (int l = random.nextInt(10); 0 < l; --l) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(maxHeight) + 60;
            int z = chunkZ * 16 + random.nextInt(16);
            for (int var6 = 0; var6 < 20; ++var6) {
                int posX = x + random.nextInt(8) - random.nextInt(8);
                int posY = y + random.nextInt(4) - random.nextInt(4);
                int posZ = z + random.nextInt(8) - random.nextInt(8);
                BlockPos pos = new BlockPos(posX, posY, posZ);
                IBlockState block = world.func_180495_p(pos.func_177977_b());
                if (!world.func_175623_d(pos) || block.func_177230_c() != Blocks.field_150349_c && block.func_177230_c() != Blocks.field_150346_d) continue;
                world.func_175656_a(pos, DataManager.getState(BambooShoot.class));
            }
        }
    }

    private void generateSakura(Random random, World world, int chunkX, int chunkZ, int maxHeight) {
        for (int l = random.nextInt(5); 0 < l; --l) {
            BlockPos orign = new BlockPos(chunkX * 16 + random.nextInt(16), random.nextInt(maxHeight) + 60, chunkZ * 16 + random.nextInt(16));
            for (int var6 = 0; var6 < 10; ++var6) {
                BlockPos pos = orign.func_177982_a(8 - random.nextInt(16), 4 - random.nextInt(8), 8 - random.nextInt(16));
                IBlockState block = world.func_180495_p(pos.func_177977_b());
                if (!world.func_175623_d(pos) || block.func_177230_c() != Blocks.field_150349_c && block.func_177230_c() != Blocks.field_150346_d) continue;
                DataManager.getBlock(SakuraSapling.class).generateTree(world, pos, DataManager.getState(SakuraSapling.class), random);
                return;
            }
        }
    }
}

