/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.KeyBindFactory;
import ruby.bamboo.core.PacketDispatcher;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.item.arrow.IBambooArrow;
import ruby.bamboo.item.itemblock.IEnumTex;
import ruby.bamboo.item.itemblock.ISubTexture;
import ruby.bamboo.packet.MessageBambooUtil;
import ruby.bamboo.util.ItemStackHelper;

@BambooData.BambooItem(createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class BambooBow
extends ItemBow
implements ISubTexture,
KeyBindFactory.IBambooKeylistener {
    public static final String TAG_AMMO = "ammo";
    public static final String AMMO_SLOT = "slot";
    public static final String ICON_NAME = "bamboomod:bamboobow";
    public static final String[] ICON_PULL_NAMES = new String[4];

    public BambooBow() {
        this.func_77656_e(400);
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        boolean isNoResource;
        int chargeFrame = this.func_77626_a(par1ItemStack) - par4;
        ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, chargeFrame);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        InventoryPlayer inv = par3EntityPlayer.field_71071_by;
        chargeFrame = event.charge;
        boolean bl = isNoResource = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
        if (this.hasInventoryBambooArrow((IInventory)inv)) {
            float power = (float)chargeFrame / 10.0f;
            if ((double)(power = (power * power + power * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (power > 1.0f) {
                power = 1.0f;
            }
            int slotNum = this.getSelectedInventorySlotContainItem((IInventory)inv, par1ItemStack);
            ItemStack stack = inv.func_70301_a(slotNum);
            IBambooArrow arrow = (IBambooArrow)stack.func_77973_b();
            arrow.execute(par2World, par1ItemStack, stack, power, chargeFrame, par3EntityPlayer);
            par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
        }
        if (!isNoResource) {
            par1ItemStack.func_77972_a(1, (EntityLivingBase)par3EntityPlayer);
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, par1ItemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        InventoryPlayer inv = par3EntityPlayer.field_71071_by;
        if (par3EntityPlayer.field_71075_bZ.field_75098_d || this.hasInventoryBambooArrow((IInventory)inv) || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public int func_77619_b() {
        return 1;
    }

    private boolean hasInventoryBambooArrow(IInventory inv) {
        return this.getInventorySlotContainItem(inv) >= 0;
    }

    private int getInventorySlotContainItem(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof IBambooArrow)) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedInventorySlotContainItem(IInventory inv, ItemStack stack) {
        byte arrowSlotNum;
        ItemStackHelper.HashedStack[] arrows = this.getArrowTypes(inv).toArray(new ItemStackHelper.HashedStack[0]);
        if (arrows.length > (arrowSlotNum = this.getArrowSlot(stack))) {
            return ItemStackHelper.getSlotNum(inv, arrows[arrowSlotNum].getItemStack());
        }
        return 0;
    }

    private Map<ItemStackHelper.HashedStack, Integer> getArrowMap(InventoryPlayer inv) {
        LinkedHashMap<ItemStackHelper.HashedStack, Integer> map = new LinkedHashMap<ItemStackHelper.HashedStack, Integer>();
        for (ItemStack stack : inv.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof IBambooArrow)) continue;
            Item item = stack.func_77973_b();
            int size = stack.field_77994_a;
            ItemStackHelper.HashedStack hashStack = new ItemStackHelper.HashedStack(stack);
            if (map.containsKey(hashStack)) {
                size += ((Integer)map.get(hashStack)).intValue();
            }
            map.put(hashStack, size);
        }
        return map;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTip(RenderGameOverlayEvent.Text e) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == this) {
            Map<ItemStackHelper.HashedStack, Integer> map = this.getArrowMap(player.field_71071_by);
            GuiIngame gui = FMLClientHandler.instance().getClient().field_71456_v;
            int maxWidth = 0;
            for (ItemStackHelper.HashedStack stack : map.keySet()) {
                int width = gui.func_175179_f().func_78256_a(stack.item.func_77653_i(stack.getItemStack()) + ":" + map.get(stack));
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            byte slotPos = this.getArrowSlot(player.func_71045_bC());
            byte nuwPos = 0;
            for (ItemStackHelper.HashedStack stack : map.keySet()) {
                byte by = nuwPos;
                nuwPos = (byte)(nuwPos + 1);
                this.draw(e, maxWidth, stack.item.func_77653_i(stack.getItemStack()) + ":" + map.get(stack), slotPos == by ? 0xE06060 : 0xE0E0E0);
            }
        }
    }

    private void draw(RenderGameOverlayEvent.Text e, int startLeftpos, String msg, int color) {
        GuiIngame gui = FMLClientHandler.instance().getClient().field_71456_v;
        int top = 2 + gui.func_175179_f().field_78288_b * e.left.size();
        int w = gui.func_175179_f().func_78256_a(msg);
        int left = e.resolution.func_78326_a() - 2 - startLeftpos;
        GuiIngame.func_73734_a((int)1, (int)(top - 1), (int)(startLeftpos + 1), (int)(top + gui.func_175179_f().field_78288_b - 1), (int)-1873784752);
        gui.func_175179_f().func_78276_b(msg, 1, top, color);
        e.left.add(null);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par5 && par3Entity instanceof EntityPlayer && !par2World.field_72995_K) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            byte types = (byte)this.getArrowTypes((IInventory)player.field_71071_by).size();
            if (this.getArrowSlot(par1ItemStack) >= types && types > 0) {
                types = (byte)(types - 1);
                par1ItemStack.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, types);
            }
        }
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        ModelResourceLocation modelresourcelocation = new ModelResourceLocation(ICON_PULL_NAMES[0], "inventory");
        InventoryPlayer inv = player.field_71071_by;
        if (stack.func_77973_b() == this && player.func_71011_bu() != null) {
            int chargeFrame = this.func_77626_a(stack) - useRemaining;
            if (this.hasInventoryBambooArrow((IInventory)inv)) {
                IBambooArrow arrow = (IBambooArrow)inv.func_70301_a(this.getSelectedInventorySlotContainItem((IInventory)inv, stack)).func_77973_b();
                modelresourcelocation = arrow.getBowModel(chargeFrame);
            } else if (chargeFrame >= 40) {
                modelresourcelocation = new ModelResourceLocation(ICON_PULL_NAMES[3], "inventory");
            } else if (chargeFrame > 25) {
                modelresourcelocation = new ModelResourceLocation(ICON_PULL_NAMES[2], "inventory");
            } else if (chargeFrame > 0) {
                modelresourcelocation = new ModelResourceLocation(ICON_PULL_NAMES[1], "inventory");
            }
        }
        return modelresourcelocation;
    }

    @Override
    public IEnumTex[] getName() {
        IEnumTex[] ret = new IEnumTex[ICON_PULL_NAMES.length];
        for (int i = 0; i < ret.length; ++i) {
            final int id = i;
            ret[i] = new IEnumTex(){

                @Override
                public int getId() {
                    return id;
                }

                @Override
                public String getJsonName() {
                    return ICON_PULL_NAMES[id];
                }
            };
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void exec(KeyBinding key) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == this && key.func_151468_f()) {
            ItemStack is = player.func_71045_bC();
            byte slotNum = this.getArrowSlot(is);
            int invArrowTypes = this.getArrowTypes((IInventory)player.field_71071_by).size();
            if ((slotNum = (byte)(slotNum + 1)) >= invArrowTypes) {
                slotNum = 0;
            }
            PacketDispatcher.sendToServer(new MessageBambooUtil(slotNum));
        }
    }

    @Override
    public void callback(EntityPlayer playerEntity, ItemStack is, byte data) {
        is.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, data);
    }

    public byte getArrowSlot(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, (byte)0);
        }
        return is.func_179543_a(TAG_AMMO, true).func_74771_c(AMMO_SLOT);
    }

    public Set<ItemStackHelper.HashedStack> getArrowTypes(IInventory inv) {
        LinkedHashSet<ItemStackHelper.HashedStack> stackSet = new LinkedHashSet<ItemStackHelper.HashedStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IBambooArrow)) continue;
            ItemStackHelper.HashedStack hashStack = new ItemStackHelper.HashedStack(stack);
            stackSet.add(hashStack);
        }
        return stackSet;
    }

    public boolean func_77651_p() {
        return true;
    }

    static {
        for (int i = 0; i < ICON_PULL_NAMES.length; ++i) {
            BambooBow.ICON_PULL_NAMES[i] = "bamboomod:bamboobow_pull_" + i;
        }
    }
}

