/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item.arrow;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.entity.arrow.BaseArrow;
import ruby.bamboo.entity.arrow.EntityAntiArrow;
import ruby.bamboo.item.BambooBow;
import ruby.bamboo.item.arrow.ArrowBase;
import ruby.bamboo.item.itemblock.IEnumTex;
import ruby.bamboo.item.itemblock.ISubTexture;
import ruby.bamboo.util.ItemStackHelper;

@BambooData.BambooItem(createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class AntiArrow
extends ArrowBase
implements ISubTexture {
    public AntiArrow() {
        this.func_77627_a(true);
    }

    @Override
    public void execute(World world, ItemStack bow, ItemStack arrow, float power, int chargeFrame, EntityPlayer player) {
        int k;
        EntityAntiArrow entityArrow = new EntityAntiArrow(world, (EntityLivingBase)player, power * 2.0f);
        entityArrow.setArrowType(AntiType.getType(arrow.func_77952_i()));
        int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow);
        if (j > 0) {
            entityArrow.func_70239_b(entityArrow.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
            entityArrow.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
            entityArrow.func_70015_d(100);
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entityArrow);
        }
        if (!this.isNoResources(player)) {
            ItemStackHelper.decrStackSize((IInventory)player.field_71071_by, arrow, 1);
        } else {
            entityArrow.field_70251_a = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        for (AntiType type : AntiType.values()) {
            if (type == AntiType.UNKNOWN) continue;
            subItems.add(new ItemStack((Item)this, 1, (int)type.getID()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + AntiType.getType(stack.func_77952_i()).name().toLowerCase();
    }

    @Override
    public ModelResourceLocation getBowModel(int useRemaining) {
        String jsonName = BambooBow.ICON_PULL_NAMES[useRemaining >= 18 ? 3 : (useRemaining > 13 ? 2 : 1)];
        return new ModelResourceLocation(jsonName, "inventory");
    }

    @Override
    public Class<? extends BaseArrow> getArrowClass() {
        return EntityAntiArrow.class;
    }

    @Override
    public IEnumTex[] getName() {
        IEnumTex[] tex = new IEnumTex[AntiType.values().length];
        ArrayList<1> list = new ArrayList<1>();
        for (final AntiType type : AntiType.values()) {
            list.add(new IEnumTex(){

                @Override
                public String getJsonName() {
                    return "bamboomod:antiarrow";
                }

                @Override
                public int getId() {
                    return type.getID();
                }
            });
        }
        return list.toArray(new IEnumTex[0]);
    }

    public static enum AntiType {
        UNKNOWN(0, new Class[0]),
        UNDEAD(1, EntityZombie.class, EntitySkeleton.class),
        MUTANT(2, EntityCreeper.class, EntityPigZombie.class),
        ENDERMAN(3, EntityEnderman.class, EntityEndermite.class),
        FLAME(4, EntityBlaze.class, EntityMagmaCube.class),
        AIR(5, EntityGhast.class, EntityBlaze.class, EntityBat.class, EntityDragon.class, EntityWither.class),
        MULTILEG(6, EntitySpider.class, EntityGhast.class, EntitySquid.class),
        HUMAN(7, EntityVillager.class, EntityWitch.class, EntityPlayer.class),
        NONLEG(8, EntitySlime.class, EntityBlaze.class, EntityWither.class, EntitySnowman.class, EntityGuardian.class),
        HARD(9, EntityIronGolem.class, EntityBlaze.class),
        SOFT(10, EntityGhast.class, EntitySlime.class),
        WATER(11, EntityGuardian.class, EntitySquid.class);

        private byte id;
        private Class<? extends Entity>[] entities;

        private AntiType(int id, Class<? extends Entity> ... entities) {
            this.id = (byte)id;
            this.entities = entities;
        }

        public byte getID() {
            return this.id;
        }

        public Class<? extends Entity>[] getEntity() {
            return this.entities;
        }

        public static AntiType getType(int id) {
            for (AntiType type : AntiType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

