/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import ruby.bamboo.block.ICustomState;
import ruby.bamboo.block.decoration.DecorationClientFactory;
import ruby.bamboo.core.DataManager;
import ruby.bamboo.core.KeyBindFactory;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EntityRegister;
import ruby.bamboo.item.BambooBow;
import ruby.bamboo.item.itemblock.IEnumTex;
import ruby.bamboo.item.itemblock.ISubTexture;
import ruby.bamboo.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registJson();
        new DecorationClientFactory().register();
        new EntityRegister().renderRegist();
        KeyBindFactory.preInit();
    }

    @Override
    public void init() {
        super.init();
        KeyBindFactory.init();
        MinecraftForge.EVENT_BUS.register((Object)DataManager.getItem(BambooBow.class));
    }

    private void registJson() {
        ArrayList isList = new ArrayList();
        ArrayList tmpNameList = new ArrayList();
        for (String name : DataManager.getRegstedNameArray()) {
            Item item = Item.func_111206_d((String)name);
            isList.clear();
            item.func_150895_a(item, item.func_77640_w(), isList);
            this.setIgnoreState(DataManager.getBlock(DataManager.getClass(name)));
            this.setCustomState(DataManager.getBlock(DataManager.getClass(name)));
            if (item instanceof ISubTexture) {
                for (IEnumTex tex : ((ISubTexture)item).getName()) {
                    String jsonName = tex.getJsonName();
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(jsonName)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)tex.getId(), (ModelResourceLocation)new ModelResourceLocation(jsonName, "inventory"));
                }
                continue;
            }
            for (int i = 0; i < isList.size(); ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
            }
        }
    }

    private <T> void setCustomState(T obj) {
        if (obj instanceof ICustomState) {
            try {
                IStateMapper state = (IStateMapper)((ICustomState)obj).getCustomState();
                ModelLoader.setCustomStateMapper((Block)((Block)obj), (IStateMapper)state);
            }
            catch (Exception e) {
                FMLLog.warning((String)(obj.getClass().getName() + ": Custom State Error"), (Object[])new Object[0]);
            }
        }
    }

    private <T> void setIgnoreState(T obj) {
        Method method = this.getMethod(obj, BambooData.BambooBlock.StateIgnore.class);
        if (method != null) {
            try {
                IProperty[] prop = (IProperty[])method.invoke(obj, new Object[0]);
                if (prop != null) {
                    ModelLoader.setCustomStateMapper((Block)((Block)obj), (IStateMapper)new StateMap.Builder().func_178442_a(prop).func_178441_a());
                }
            }
            catch (Exception e) {
                FMLLog.warning((String)(obj.getClass().getName() + "Ignore State Error"), (Object[])new Object[0]);
            }
        }
    }

    private <T> Method getMethod(T obj, Class<? extends Annotation> ano) {
        if (obj == null) {
            return null;
        }
        Method method = null;
        for (Method e : obj.getClass().getDeclaredMethods()) {
            if (e.getAnnotation(ano) == null) continue;
            method = e;
            break;
        }
        return method;
    }
}

