/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.util;

import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackHelper {
    private static final int armorSlotCount = 4;

    public static boolean hasDecrStackSize(IInventory inv, ItemStack stack, int count) {
        return ItemStackHelper.getInventoryStackSize(inv, stack) >= count;
    }

    public static int getInventoryStackSize(IInventory inv, ItemStack stack) {
        int invCount = 0;
        for (int i = 0; i < inv.func_70302_i_() - 4; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            invCount += is.field_77994_a;
        }
        return invCount;
    }

    public static boolean decrStackSize(IInventory inv, ItemStack stack, int count) {
        if (!ItemStackHelper.hasDecrStackSize(inv, stack, count)) {
            return false;
        }
        for (int i = inv.func_70302_i_() - 4; 0 <= i && count > 0; --i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            if ((count -= is.field_77994_a) >= 0) {
                inv.func_70299_a(i, null);
                continue;
            }
            inv.func_70298_a(i, count + is.field_77994_a);
        }
        return true;
    }

    public static int getSlotNum(IInventory inv, ItemStack stack) {
        for (int i = inv.func_70302_i_() - 4; 0 <= i; --i) {
            ItemStack is = inv.func_70301_a(i);
            if (!stack.func_77969_a(is)) continue;
            return i;
        }
        return -1;
    }

    public static class HashedStack {
        public final Item item;
        public final int damage;
        public final int stackSize;

        public HashedStack(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.damage = stack.func_77952_i();
            this.stackSize = stack.field_77994_a;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof HashedStack) {
                return super.equals(obj) || this.hashCode() == obj.hashCode();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.damage);
        }

        public ItemStack getItemStack() {
            return new ItemStack(this.item, this.stackSize, this.damage);
        }
    }
}

