/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import ruby.bamboo.api.crafting.grind.IGrindRecipe;
import ruby.bamboo.gui.GuiMillStone;
import ruby.bamboo.item.crafting.GrindManager;

public class GrindRecipeHandler
extends TemplateRecipeHandler {
    public static final String RECIPE_NAME = "Grind Recipe";

    public String getRecipeName() {
        return RECIPE_NAME;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64, 23, 24, 18), RECIPE_NAME, new Object[0]));
    }

    public String getGuiTexture() {
        return "bamboo:textures/guis/neiguimillstone.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMillStone.class;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(RECIPE_NAME)) {
            for (IGrindRecipe recipe : GrindManager.getRecipeList()) {
                this.arecipes.add(new CachedGrindRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IGrindRecipe recipe : GrindManager.getRecipeList()) {
            if (!result.func_77969_a(recipe.getOutput()) && (recipe.getBonus() == null || !result.func_77969_a(recipe.getBonus()))) continue;
            this.arecipes.add(new CachedGrindRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack input) {
        for (IGrindRecipe recipe : GrindManager.getRecipeList()) {
            if (input.func_77973_b() != recipe.getInput().getItem() || recipe.getInput().getItemDamage() != Short.MAX_VALUE && input.func_77960_j() != recipe.getInput().getItemDamage()) continue;
            this.arecipes.add(new CachedGrindRecipe(recipe));
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(65, 22, 176, 0 + 16 * ((this.cycleticks >> 3) % 4), 16, 16, 1.0f, 1);
        this.drawProgressBar(65, 40, 192, 0 + 6 * ((this.cycleticks >> 3) % 4), 16, 6, 1.0f, 1);
    }

    public class CachedGrindRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack input;
        private ItemStack result;
        private ItemStack bonus;

        public CachedGrindRecipe(ItemStack input, ItemStack result, ItemStack bonus) {
            super((TemplateRecipeHandler)GrindRecipeHandler.this);
            this.input = input;
            this.result = result;
            this.bonus = bonus;
        }

        public CachedGrindRecipe(IGrindRecipe recipe) {
            this(recipe.getInput().getItemStack(), recipe.getOutput(), recipe.getBonus());
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.input, 33, 24);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.result, 101, 24);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.bonus != null) {
                stacks.add(new PositionedStack((Object)this.bonus, 132, 24));
            }
            return stacks;
        }
    }
}

