/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ruby.bamboo.entity.EntityObon;
import ruby.bamboo.render.ModelObon;

public class RenderObon
extends Render {
    private static final ResourceLocation res = new ResourceLocation("bamboo:textures/entitys/obon.png");
    protected static final RenderItem itemRenderer = new RenderItem();
    private final ModelObon model;
    private final Random random;
    private List<ItemStack> renderItems = new ArrayList<ItemStack>();
    private float f;

    public RenderObon() {
        this.model = new ModelObon();
        this.random = new Random();
        itemRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        this.doRender((EntityObon)entity, d0, d1, d2, f, f1);
    }

    public void doRender(EntityObon entity, double d0, double d1, double d2, float f, float f1) {
        GL11.glPushMatrix();
        this.func_110777_b(entity);
        GL11.glTranslatef((float)((float)d0), (float)((float)d1 + 0.2f), (float)((float)d2));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(entity.field_70177_z + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        this.renderItems.clear();
        int i = 0;
        while (true) {
            if (i >= 5) break;
            ItemStack is = entity.getItemData(i);
            if (is != null) {
                if (is.func_77973_b() != EntityObon.EMPTY.func_77973_b()) {
                    this.renderItems.add(is);
                }
            }
            ++i;
        }
        int b = 0;
        float distance = 0.25f;
        float angle = 360.0f / (float)this.renderItems.size();
        if (this.renderItems.size() != 1) {
            for (ItemStack is : this.renderItems) {
                int n = b;
                b = (byte)(b + 1);
                double rad = Math.toRadians(angle * (float)n + (entity.field_70177_z + 180.0f));
                if (this.renderItems.size() == 3) {
                    rad += 0.5;
                } else if (this.renderItems.size() == 4) {
                    rad -= 0.78;
                    distance = 0.3f;
                } else if (this.renderItems.size() == 5) {
                    rad -= 0.32;
                    distance = 0.325f;
                }
                double offsetX = (double)distance * Math.cos(rad);
                double offsetZ = (double)distance * Math.sin(rad);
                this.doRenderItem(is, d0 + offsetX, d1 + 0.18, d2 + offsetZ, f, f1);
            }
        } else {
            this.doRenderItem(this.renderItems.get(0), d0, d1 + 0.18, d2, 0.0f, 0.0625f);
        }
        GL11.glPopMatrix();
    }

    private ResourceLocation func_110796_a(ItemStack itemStack) {
        return this.field_76990_c.field_78724_e.func_130087_a(itemStack.func_94608_d());
    }

    public void doRenderItem(ItemStack itemStack, double par2, double par4, double par6, float par8, float par9) {
        this.func_110776_a(this.func_110796_a(itemStack));
        this.random.setSeed(187L);
        if (itemStack.func_77973_b() != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 0.1f), (float)((float)par6));
            int b0 = 1;
            GL11.glEnable((int)32826);
            if (itemStack.func_94608_d() == 1 && itemStack.func_77973_b().func_77623_v()) {
                GL11.glScalef((float)0.5128205f, (float)0.5128205f, (float)0.5128205f);
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                for (int k = 0; k < itemStack.func_77973_b().getRenderPasses(itemStack.func_77960_j()); ++k) {
                    this.random.setSeed(187L);
                    IIcon icon = itemStack.func_77973_b().getIcon(itemStack, k);
                    float f8 = 1.0f;
                    int i = itemStack.func_77973_b().func_82790_a(itemStack, k);
                    float f5 = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f6 = (float)(i & 0xFF) / 255.0f;
                    GL11.glColor4f((float)(f5 * f8), (float)(f4 * f8), (float)(f6 * f8), (float)1.0f);
                    this.renderDroppedItem(itemStack, icon, b0, par9, f5 * f8, f4 * f8, f6 * f8, k);
                }
            } else {
                GL11.glScalef((float)0.5128205f, (float)0.5128205f, (float)0.5128205f);
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                IIcon icon1 = itemStack.func_77954_c();
                int l = itemStack.func_77973_b().func_82790_a(itemStack, 0);
                float f8 = (float)(l >> 16 & 0xFF) / 255.0f;
                float f9 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(l & 0xFF) / 255.0f;
                float f4 = 1.0f;
                this.renderDroppedItem(itemStack, icon1, b0, par9, f8 * f4, f9 * f4, f5 * f4);
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    private byte getMiniBlockCount(ItemStack stack) {
        byte ret = 1;
        if (stack.field_77994_a > 1) {
            ret = 2;
        }
        if (stack.field_77994_a > 5) {
            ret = 3;
        }
        if (stack.field_77994_a > 20) {
            ret = 4;
        }
        if (stack.field_77994_a > 40) {
            ret = 5;
        }
        return ret;
    }

    private void renderDroppedItem(ItemStack itemStack, IIcon par2Icon, int par3, float par4, float par5, float par6, float par7) {
        this.renderDroppedItem(itemStack, par2Icon, par3, par4, par5, par6, par7, 0);
    }

    private void renderDroppedItem(ItemStack itemStack, IIcon par2Icon, int par3, float par4, float par5, float par6, float par7, int pass) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (par2Icon == null) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation resourcelocation = texturemanager.func_130087_a(itemStack.func_94608_d());
            par2Icon = ((TextureMap)texturemanager.func_110581_b(resourcelocation)).func_94245_a("missingno");
        }
        float f4 = par2Icon.func_94209_e();
        float f5 = par2Icon.func_94212_f();
        float f6 = par2Icon.func_94206_g();
        float f7 = par2Icon.func_94210_h();
        float f8 = 1.0f;
        float f9 = 0.5f;
        float f10 = 0.25f;
        for (int l = 0; l < par3; ++l) {
            GL11.glPushMatrix();
            if (l > 0) {
                float f11 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float f16 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float f17 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)f11, (float)f16, (float)f17);
            }
            GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)par5, (float)par6, (float)par7, (float)1.0f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            tessellator.func_78374_a((double)(0.0f - f9), (double)(0.0f - f10), 0.0, (double)f4, (double)f7);
            tessellator.func_78374_a((double)(f8 - f9), (double)(0.0f - f10), 0.0, (double)f5, (double)f7);
            tessellator.func_78374_a((double)(f8 - f9), (double)(1.0f - f10), 0.0, (double)f5, (double)f6);
            tessellator.func_78374_a((double)(0.0f - f9), (double)(1.0f - f10), 0.0, (double)f4, (double)f6);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return res;
    }
}

