/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.Config;
import ruby.bamboo.CustomRenderHandler;
import ruby.bamboo.tileentity.TileEntityMultiBlock;

public class BlockMultiBlock
extends BlockContainer {
    private byte renderSide = (byte)63;
    private byte innerX;
    private byte innerY;
    private byte innerZ;

    public BlockMultiBlock() {
        super(Material.field_151578_c);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            for (ItemStack is : ((TileEntityMultiBlock)tile).getInnnerBlocks()) {
                this.func_149642_a(world, x, y, z, is);
            }
            this.func_149642_a(world, x, y, z, new ItemStack(block, 1, (int)((TileEntityMultiBlock)tile).getFieldSize()));
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149645_b() {
        return CustomRenderHandler.multiBlockUID;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity tile = iblockaccess.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            return ((TileEntityMultiBlock)tile).getInnerBlock(this.innerX, this.innerY, this.innerZ).func_149720_d((IBlockAccess)tile, (int)this.innerX, (int)this.innerY, (int)this.innerZ);
        }
        return super.func_149720_d(iblockaccess, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && this.canUse(par5EntityPlayer) && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityMultiBlock) {
            ItemStack is = par5EntityPlayer.func_71045_bC();
            if (is != null && this.canPlaceBlock(Block.func_149634_a((Item)is.func_77973_b()))) {
                Block block = Block.func_149634_a((Item)is.func_77973_b());
                int innerMeta = block.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, is.func_77960_j());
                ItemStack copy = is.func_77946_l();
                copy.func_77964_b(innerMeta);
                if (((TileEntityMultiBlock)tile).setInnerBlock(world, hitX, hitY, hitZ, side, copy)) {
                    if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                        --is.field_77994_a;
                    }
                    world.func_147471_g(x, y, z);
                }
            } else {
                ItemStack res = ((TileEntityMultiBlock)tile).removeInnerBlock(hitX, hitY, hitZ, side);
                if (res != null) {
                    if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                        this.func_149642_a(world, x, y, z, res);
                    }
                    world.func_147471_g(x, y, z);
                }
            }
        }
        return true;
    }

    public boolean canUse(EntityPlayer player) {
        if (Config.multiBlockRestraint == 0) {
            return true;
        }
        if (Config.multiBlockRestraint == 1) {
            return player.field_71075_bZ.field_75098_d;
        }
        if (Config.multiBlockRestraint == 2) {
            return player.field_71075_bZ.field_75098_d || player.func_70003_b(MinecraftServer.func_71276_C().func_110455_j(), "stop");
        }
        if (Config.multiBlockRestraint == 3) {
            return player.func_70003_b(MinecraftServer.func_71276_C().func_110455_j(), "stop");
        }
        return false;
    }

    public boolean canPlaceBlock(Block block) {
        return block.func_149645_b() == 0 && this.isCube(block) || block.func_149721_r();
    }

    public boolean isCube(Block block) {
        return block.func_149704_x() == 0.0 && block.func_149665_z() == 0.0 && block.func_149706_B() == 0.0 && block.func_149753_y() == 1.0 && block.func_149669_A() == 1.0 && block.func_149693_C() == 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB bb, List list, Entity entiyt) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            int meta = world.func_72805_g(x, y, z);
            if (((TileEntityMultiBlock)tile).isEmpty()) {
                this.setBoundsForMeta(meta);
                super.func_149743_a(world, x, y, z, bb, list, entiyt);
            } else {
                float f = 1.0f / (float)((TileEntityMultiBlock)tile).getFieldSize();
                for (int innerX = 0; innerX < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerX) {
                    for (int innerY = 0; innerY < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerY) {
                        for (int innerZ = 0; innerZ < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerZ) {
                            if (!((TileEntityMultiBlock)tile).isExist(innerX, innerY, innerZ)) continue;
                            this.func_149676_a(f * (float)innerX, f * (float)innerY, f * (float)innerZ, f * (float)innerX + f, f * (float)innerY + f, f * (float)innerZ + f);
                            super.func_149743_a(world, x, y, z, bb, list, entiyt);
                        }
                    }
                }
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3Start, Vec3 vec3End) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            MovingObjectPosition[] mop = new MovingObjectPosition[(int)Math.pow(((TileEntityMultiBlock)tile).getFieldSize(), 3.0) + 1];
            int count = 0;
            if (((TileEntityMultiBlock)tile).isEmpty()) {
                this.setBoundsForMeta(tile.func_145832_p());
                mop[count++] = super.func_149731_a(world, x, y, z, vec3Start, vec3End);
            } else {
                float f = 1.0f / (float)((TileEntityMultiBlock)tile).getFieldSize();
                for (int innerX = 0; innerX < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerX) {
                    for (int innerY = 0; innerY < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerY) {
                        for (int innerZ = 0; innerZ < ((TileEntityMultiBlock)tile).getFieldSize(); ++innerZ) {
                            if (!((TileEntityMultiBlock)tile).isExist(innerX, innerY, innerZ)) continue;
                            this.func_149676_a(f * (float)innerX, f * (float)innerY, f * (float)innerZ, f * (float)innerX + f, f * (float)innerY + f, f * (float)innerZ + f);
                            mop[count++] = super.func_149731_a(world, x, y, z, vec3Start, vec3End);
                        }
                    }
                }
            }
            double d1 = 0.0;
            int i2 = count;
            MovingObjectPosition movingobjectposition1 = null;
            for (int j2 = 0; j2 < i2; ++j2) {
                double d0;
                MovingObjectPosition movingobjectposition = mop[j2];
                if (movingobjectposition == null || !((d0 = movingobjectposition.field_72307_f.func_72436_e(vec3End)) > d1)) continue;
                movingobjectposition1 = movingobjectposition;
                d1 = d0;
            }
            return movingobjectposition1;
        }
        return super.func_149731_a(world, x, y, z, vec3Start, vec3End);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.setBoundsForMeta(world.func_72805_g(x, y, z));
        return super.func_149633_g(world, x, y, z);
    }

    public void setBoundsForMeta(int meta) {
        float f = 0.001f;
        switch (ForgeDirection.VALID_DIRECTIONS[meta]) {
            case DOWN: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UP: {
                this.func_149676_a(0.0f, 1.0f - f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return ForgeDirection.OPPOSITES[par5];
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setInnerPos(byte x, byte y, byte z, byte renderSide) {
        this.innerX = x;
        this.innerY = y;
        this.innerZ = z;
        this.renderSide = renderSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntity tile = iBlockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            TileEntityMultiBlock tileMulti = (TileEntityMultiBlock)tile;
            if (!((TileEntityMultiBlock)tile).isEmpty()) {
                return tileMulti.getInnerBlock(this.innerX, this.innerY, this.innerZ).func_149691_a(side, tileMulti.getInnerMeta(this.innerX, this.innerY, this.innerZ));
            }
        }
        return this.field_149761_L;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par5 != 1 && (this.renderSide >> par5 & 1) == 1;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMultiBlock();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a("bamboo:multiblock");
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "bamboo:multiblock";
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack is = super.getPickBlock(target, world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMultiBlock) {
            is.func_77964_b((int)((TileEntityMultiBlock)tile).getFieldSize());
            is.field_77990_d = new NBTTagCompound();
            ((TileEntityMultiBlock)tile).writeToSlotNBT(is.field_77990_d);
        } else {
            is.func_77964_b(3);
        }
        return is;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float dropRate, int fortune) {
    }
}

