/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import ruby.bamboo.BambooInit;
import ruby.bamboo.item.KatanaDropItem;

public class KatanaDropManager {
    private static final Random rand = new Random(System.currentTimeMillis());
    private static final HashMap<Class<? extends EntityLivingBase>, List<KatanaDropItem>> dropTable = new HashMap();

    public static void addDrop(Class<? extends EntityLivingBase> entityCls, KatanaDropItem item) {
        if (dropTable.containsKey(entityCls)) {
            dropTable.get(entityCls).add(item);
        } else {
            ArrayList<KatanaDropItem> list = new ArrayList<KatanaDropItem>();
            list.add(item);
            dropTable.put(entityCls, list);
        }
    }

    public static ItemStack getRandomDrop(Class<? extends EntityLivingBase> entityCls) {
        if (dropTable.containsKey(entityCls)) {
            List<KatanaDropItem> list = dropTable.get(entityCls);
            KatanaDropItem drop = list.get(rand.nextInt(list.size()));
            if (rand.nextFloat() < drop.getReality()) {
                ItemStack result = drop.getDropItem().func_77946_l();
                if (drop.getRandomAmount() != 0) {
                    result.field_77994_a += rand.nextInt(drop.getRandomAmount() + 1);
                }
                return result;
            }
        }
        return null;
    }

    static {
        KatanaDropManager.addDrop(EntityZombie.class, new KatanaDropItem(new ItemStack(Items.field_151116_aA), 0.2f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityZombie.class, new KatanaDropItem(new ItemStack(Items.field_151103_aS), 0.2f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityZombie.class, new KatanaDropItem(new ItemStack(Items.field_151144_bL, 1, 2), 0.002f));
        KatanaDropManager.addDrop(EntitySkeleton.class, new KatanaDropItem(new ItemStack(Items.field_151144_bL, 1, 0), 0.002f));
        KatanaDropManager.addDrop(EntitySkeleton.class, new KatanaDropItem(new ItemStack(Items.field_151144_bL, 1, 1), 0.001f));
        KatanaDropManager.addDrop(EntityCreeper.class, new KatanaDropItem(new ItemStack(Items.field_151016_H), 0.2f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityCreeper.class, new KatanaDropItem(new ItemStack(Blocks.field_150335_W), 0.01f).setRandomAddAmount(2));
        KatanaDropManager.addDrop(EntityCreeper.class, new KatanaDropItem(new ItemStack(BambooInit.firecracker, 1, 0), 0.5f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityCreeper.class, new KatanaDropItem(new ItemStack(Items.field_151144_bL, 1, 4), 0.002f));
        KatanaDropManager.addDrop(EntitySpider.class, new KatanaDropItem(new ItemStack(Blocks.field_150321_G), 0.1f));
        KatanaDropManager.addDrop(EntitySpider.class, new KatanaDropItem(new ItemStack(Items.field_151059_bz), 0.5f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntitySpider.class, new KatanaDropItem(new ItemStack(Blocks.field_150335_W), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntitySpider.class, new KatanaDropItem(new ItemStack(Items.field_151114_aO), 0.5f).setRandomAddAmount(8));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack((Block)Blocks.field_150328_O), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack((Block)Blocks.field_150327_N), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack((Block)Blocks.field_150338_P), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack(Blocks.field_150419_aX), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack(Items.field_151061_bv), 0.05f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack(BambooInit.bamboo, 1, 0), 0.05f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityEnderman.class, new KatanaDropItem(new ItemStack(BambooInit.sakura, 1, 0), 0.05f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntitySilverfish.class, new KatanaDropItem(new ItemStack(Items.field_151121_aF), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityBlaze.class, new KatanaDropItem(new ItemStack(Items.field_151059_bz), 0.1f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityPig.class, new KatanaDropItem(new ItemStack(Items.field_151116_aA), 0.5f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntitySheep.class, new KatanaDropItem(new ItemStack(Items.field_151007_F), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityBat.class, new KatanaDropItem(new ItemStack(Items.field_151034_e), 0.5f).setRandomAddAmount(2));
        KatanaDropManager.addDrop(EntityBat.class, new KatanaDropItem(new ItemStack(Items.field_151153_ao), 0.01f));
        KatanaDropManager.addDrop(EntityVillager.class, new KatanaDropItem(new ItemStack(BambooInit.villagerBlock), 0.002f));
        KatanaDropManager.addDrop(EntityWitch.class, new KatanaDropItem(new ItemStack(Blocks.field_150392_bi), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityWitch.class, new KatanaDropItem(new ItemStack(Items.field_151069_bo), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityChicken.class, new KatanaDropItem(new ItemStack(Items.field_151110_aK), 0.25f).setRandomAddAmount(2));
        KatanaDropManager.addDrop(EntityWolf.class, new KatanaDropItem(new ItemStack(Items.field_151103_aS), 0.5f).setRandomAddAmount(2));
        KatanaDropManager.addDrop(EntityWolf.class, new KatanaDropItem(new ItemStack(Items.field_151082_bd), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityWolf.class, new KatanaDropItem(new ItemStack(Items.field_151147_al), 0.5f).setRandomAddAmount(3));
        KatanaDropManager.addDrop(EntityWolf.class, new KatanaDropItem(new ItemStack(Items.field_151076_bf), 0.5f));
        KatanaDropManager.addDrop(EntityWolf.class, new KatanaDropItem(new ItemStack(Items.field_151008_G), 0.5f).setRandomAddAmount(4));
        KatanaDropManager.addDrop(EntityOcelot.class, new KatanaDropItem(new ItemStack(Items.field_151115_aP), 0.75f).setRandomAddAmount(2));
    }
}

