/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.client.renderer;

import com.bonker.bananarangs.common.item.BRItems;
import com.bonker.bananarangs.common.item.BananarangItem;
import com.bonker.bananarangs.common.item.UpgradeItem;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class BananarangBEWLR
extends BlockEntityWithoutLevelRenderer {
    public static final ResourceLocation BASE_LOC = new ResourceLocation("bananarangs", "item/upgrades/bananarang_base");
    public static BananarangBEWLR INSTANCE;
    public static final List<String> BOTTOM_UPGRADES;
    public static final List<String> TOP_UPGRADES;
    private List<String> upgrades;
    private int upgrade1 = 0;
    private int upgrade2 = 0;
    boolean upgrade1switched = false;
    long lastUpgrade2switched = 0L;

    public static IClientItemExtensions EXTENSION() {
        return new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return INSTANCE;
            }
        };
    }

    public BananarangBEWLR(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    private void fillUpgradeList() {
        if (this.upgrades == null) {
            this.upgrades = new ImmutableList.Builder().addAll(UpgradeItem.UPGRADE_MAP.keySet()).build();
        }
    }

    private int nextUpgrade(int currentIndex, String otherUpgrade) {
        UpgradeItem upgrade = UpgradeItem.UPGRADE_MAP.get(otherUpgrade);
        if (++currentIndex == this.upgrades.size()) {
            currentIndex = 0;
        }
        String nextUpgrade = this.upgrades.get(currentIndex);
        while (upgrade == null || !upgrade.isCompatible(nextUpgrade)) {
            if (++currentIndex == this.upgrades.size()) {
                currentIndex = 0;
            }
            nextUpgrade = this.upgrades.get(currentIndex);
        }
        return currentIndex;
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        String layer2;
        String layer1;
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (stack.m_41720_() == BRItems.TAB_ICON.get()) {
            this.fillUpgradeList();
            long seconds = System.currentTimeMillis() / 1000L;
            if (seconds % 5L == 0L && !this.upgrade1switched) {
                this.upgrade1 = this.nextUpgrade(this.upgrade1, this.upgrades.get(this.upgrade2));
                this.upgrade1switched = true;
            } else {
                boolean bl = this.upgrade1switched = seconds % 5L == 0L;
                if (seconds % 5L != 0L && seconds > this.lastUpgrade2switched) {
                    this.upgrade2 = this.nextUpgrade(this.upgrade2, this.upgrades.get(this.upgrade1));
                    this.lastUpgrade2switched = seconds;
                }
            }
            layer1 = this.upgrades.get(this.upgrade1);
            layer2 = this.upgrades.get(this.upgrade2);
        } else {
            layer1 = BananarangItem.getUpgradeInSlot(stack, 0);
            layer2 = BananarangItem.getUpgradeInSlot(stack, 1);
        }
        if (BOTTOM_UPGRADES.contains(layer2) || TOP_UPGRADES.contains(layer1)) {
            String temp = layer2;
            layer2 = layer1;
            layer1 = temp;
        }
        boolean shouldRender1 = UpgradeItem.isValid(layer1);
        boolean shouldRender2 = UpgradeItem.isValid(layer2);
        int topLayer = 0;
        if (shouldRender1) {
            topLayer = 1;
        }
        if (shouldRender2) {
            topLayer = 2;
        }
        BananarangBEWLR.render(stack, BASE_LOC, displayContext, poseStack, bufferSource, RenderType.m_110451_(), topLayer == 0, packedLight, packedOverlay);
        if (shouldRender1) {
            BananarangBEWLR.render(stack, UpgradeItem.UPGRADE_MODEL_MAP.get(layer1), displayContext, poseStack, bufferSource, RenderType.m_110466_(), topLayer == 1, packedLight, packedOverlay);
        }
        if (shouldRender2) {
            BananarangBEWLR.render(stack, UpgradeItem.UPGRADE_MODEL_MAP.get(layer2), displayContext, poseStack, bufferSource, RenderType.m_110466_(), topLayer == 2, packedLight, packedOverlay);
        }
    }

    private static void render(ItemStack stack, ResourceLocation modelLoc, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, RenderType renderType, boolean topLayer, int packedLight, int packedOverlay) {
        ItemStack attachedItem;
        boolean inGui;
        poseStack.m_85836_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelLoc);
        model = model.applyTransform(displayContext, poseStack, BananarangBEWLR.isLeftHand(displayContext));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        renderType = RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)true);
        VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (stack.m_41790_() && topLayer ? 1 : 0) != 0);
        itemRenderer.m_115189_(model, ItemStack.f_41583_, packedLight, packedOverlay, poseStack, vertexConsumer);
        boolean bl = inGui = displayContext == ItemDisplayContext.GUI;
        if (inGui) {
            Lighting.m_84930_();
        }
        if (topLayer && !(attachedItem = BananarangItem.getAttachedItem(stack)).m_41619_()) {
            if (displayContext == ItemDisplayContext.GUI) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_85837_(-0.7, -0.7, 0.0);
                poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            } else {
                poseStack.m_85837_(0.125, 0.232, 0.531);
                poseStack.m_85841_(0.7f, 0.7f, 0.7f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            itemRenderer.m_269128_(attachedItem, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, null, 42);
        }
        if (inGui) {
            ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }

    private static boolean isLeftHand(ItemDisplayContext displayContext) {
        return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    static {
        BOTTOM_UPGRADES = List.of("flaming", "sticky", "explosive");
        TOP_UPGRADES = List.of("piercing", "fling", "pickaxe");
    }
}

