/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.common.entity;

import com.bonker.bananarangs.common.BRDamage;
import com.bonker.bananarangs.common.entity.BREntities;
import com.bonker.bananarangs.common.item.BRItems;
import com.bonker.bananarangs.common.item.BananarangItem;
import com.bonker.bananarangs.util.MathUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;

public class BananarangEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(BananarangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> DATA_RETURNING = SynchedEntityData.m_135353_(BananarangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double deceleration = 0.96;
    private static final double speedThreshold = 0.16;
    private static final double maxSpeed = 2.0;
    public static final float HITBOX_SIZE = 0.65f;
    private int age = 0;
    private boolean hasPickaxe = false;
    private ItemStack attachedItem = ItemStack.f_41583_;
    private float pickaxeEfficiency = 0.0f;
    private boolean flaming = false;
    private boolean piercing = false;
    private boolean fling = false;
    private int damageUpgrade = 0;
    private boolean sticky = false;
    private boolean explosive = false;
    private final ArrayList<Entity> stuckEntities = new ArrayList();

    public BananarangEntity(EntityType<? extends BananarangEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static void shootFromEntity(ServerLevel level, LivingEntity shooter, ItemStack stack) {
        double power = 0.9 * (1.0 + 0.4 * BananarangItem.powerUpgrade(stack));
        ((EntityType)BREntities.BANANARANG.get()).m_262455_(level, null, entity -> {
            entity.m_5602_((Entity)shooter);
            entity.setItem(stack);
            entity.m_146884_(shooter.m_146892_().m_82492_(0.0, (double)0.325f, 0.0));
            entity.m_19915_(shooter.m_146909_(), shooter.m_146908_());
            entity.m_20256_(shooter.m_20154_().m_82542_(power, power, power));
        }, BlockPos.f_121853_, MobSpawnType.COMMAND, false, false);
    }

    public void m_8119_() {
        HitResult hitResult;
        Entity owner = this.m_19749_();
        if (owner != null) {
            Vec3 targetPos = owner.m_146892_().m_82492_(0.0, (double)0.325f, 0.0);
            if (this.isReturning()) {
                if (!owner.m_6084_()) {
                    this.drop();
                }
                if (this.shouldDrop(targetPos)) {
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        for (Entity entity : this.stuckEntities) {
                            entity.m_8127_();
                            entity.m_20256_(this.m_20184_());
                        }
                        if (player.m_150110_().f_35937_ || player.m_36356_(this.m_7846_())) {
                            this.m_146870_();
                        } else {
                            this.drop();
                        }
                        player.m_36335_().m_41524_((Item)BRItems.BANANARANG.get(), 10);
                        return;
                    }
                    this.drop();
                    return;
                }
                this.m_20256_(this.m_20184_().m_82490_(0.98).m_82549_(targetPos.m_82546_(this.m_20182_()).m_82541_().m_82490_(0.05)));
            } else {
                this.scaleDelta(0.96);
                this.updateReturning();
            }
        }
        Vec3 posOld = this.m_20182_();
        this.m_146884_(posOld.m_82549_(this.m_20184_()));
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hasPickaxe && !this.isReturning()) {
                for (BlockPos pos : MathUtil.insideHitbox(this.m_20191_())) {
                    BlockState state = this.f_19853_.m_8055_(pos);
                    if (this.canMine(state, pos)) {
                        this.f_19853_.m_46961_(pos, false);
                        if (owner instanceof Player) {
                            Player player = (Player)owner;
                            if (!player.m_150110_().f_35937_ && this.attachedItem.m_220157_(1, this.f_19853_.f_46441_, null)) {
                                this.attachedItem.m_41774_(1);
                                this.attachedItem.m_41721_(0);
                                this.m_216990_(SoundEvents.f_12018_);
                                this.updateAttachedItem();
                                break;
                            }
                        }
                        this.updateAttachedItem();
                        LootContext.Builder contextBuilder = new LootContext.Builder(serverLevel).m_230911_(this.f_19853_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81461_, (Object)state).m_78972_(LootContextParams.f_81463_, (Object)this.attachedItem);
                        for (ItemStack drop : state.m_60724_(contextBuilder)) {
                            Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)drop);
                        }
                        state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
                        this.scaleDelta(Math.max(0.0, 1.0 - (double)state.m_60800_((BlockGetter)this.f_19853_, pos) / 1.5 / (double)(this.pickaxeEfficiency + 1.0f)));
                    }
                    this.updateReturning();
                }
            }
        }
        if ((hitResult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        this.m_146884_(posOld);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.sticky) {
            this.stuckEntities.addAll(this.f_19853_.m_142425_((EntityTypeTest)EntityType.f_20461_, this.m_20191_().m_82400_(2.0), e -> true));
            for (int i = 0; i < this.stuckEntities.size(); ++i) {
                Entity entity = this.stuckEntities.get(i);
                if (entity.m_20280_((Entity)this) > 16.0) {
                    this.stuckEntities.remove(entity);
                    continue;
                }
                if (!this.m_20197_().contains(entity)) {
                    entity.m_7998_((Entity)this, true);
                }
                for (int j = 0; j < 4; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123753_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.f_19853_.f_46441_.m_188501_() * 0.1, (double)this.f_19853_.f_46441_.m_188501_() * 0.1, (double)this.f_19853_.f_46441_.m_188501_() * 0.1);
                }
            }
        }
        if (++this.age >= 200) {
            this.drop();
        }
    }

    protected void m_6532_(HitResult pResult) {
        if (this.explosive && !this.isReturning()) {
            this.explode();
        }
        super.m_6532_(pResult);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity owner;
        Entity entity = hitResult.m_82443_();
        if (entity != (owner = this.m_19749_())) {
            float damage = 6.0f + 3.0f * (float)this.damageUpgrade;
            if (this.piercing) {
                damage = (float)((double)damage * 0.5);
            }
            entity.m_6469_(this.createDamageSource(), damage);
            if (!this.piercing) {
                Vec3 delta = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
                if (this.fling) {
                    delta = delta.m_82490_(2.0);
                } else {
                    double d;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        d = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    } else {
                        d = 0.0;
                    }
                    double knockbackResistance = d;
                    delta = delta.m_82490_(0.1 * knockbackResistance);
                }
                if (!this.sticky) {
                    entity.m_5997_(delta.f_82479_, this.fling ? 0.5 : 0.01, delta.f_82481_);
                }
                if (this.m_6060_()) {
                    entity.m_20254_(5);
                }
                this.setReturning(true);
            }
            if (this.sticky) {
                this.stuckEntities.add(entity);
            }
        }
    }

    private void explode() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_214150_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 0.4f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.3f, 42L);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 1.5, 1.5, 1.5, 0.0);
        }
        float radius = switch (this.damageUpgrade) {
            case 1 -> 1.3f;
            case 2 -> 1.8f;
            case 3 -> 2.4f;
            default -> 1.0f;
        };
        Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82542_(0.3, 0.3, 0.3));
        this.f_19853_.m_255278_((Entity)this, this.createDamageSource(), null, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, this.flaming, Level.ExplosionInteraction.TNT, false);
        this.setReturning(true);
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public double m_6048_() {
        return -0.2;
    }

    private DamageSource createDamageSource() {
        BRDamage.Type damageType = BRDamage.Type.NORMAL;
        if (this.piercing) {
            damageType = BRDamage.Type.PIERCING;
        }
        if (this.explosive) {
            damageType = BRDamage.Type.EXPLOSIVE;
        }
        return new BRDamage.BananarangDamageSource(damageType, this, this.m_19749_());
    }

    private void updateAttachedItem() {
        ItemStack bananarang = this.m_7846_();
        BananarangItem.setAttachedItem(bananarang, this.attachedItem);
        this.setItem(bananarang);
    }

    public void setUpgrades(ItemStack bananarang) {
        this.hasPickaxe = BananarangItem.hasPickaxe(bananarang);
        this.attachedItem = BananarangItem.getAttachedItem(bananarang);
        this.pickaxeEfficiency = BananarangItem.pickaxeEfficiency(bananarang);
        this.flaming = BananarangItem.hasUpgrade(bananarang, "flaming");
        if (this.flaming) {
            this.m_20254_(100);
        }
        this.piercing = BananarangItem.hasUpgrade(bananarang, "piercing");
        this.fling = BananarangItem.hasUpgrade(bananarang, "fling");
        this.damageUpgrade = BananarangItem.damageUpgrade(bananarang);
        this.sticky = BananarangItem.hasUpgrade(bananarang, "sticky");
        this.explosive = BananarangItem.hasUpgrade(bananarang, "explosive");
    }

    private boolean canMine(BlockState state, BlockPos pos) {
        Item item = this.attachedItem.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            double destroySpeed = state.m_60800_((BlockGetter)this.f_19853_, pos);
            return destroySpeed >= 0.0 && state.m_60734_().f_60443_ && TierSortingRegistry.isCorrectTierForDrops((Tier)diggerItem.m_43314_(), (BlockState)state) && destroySpeed <= (double)(5.0f + this.pickaxeEfficiency * 10.0f);
        }
        return false;
    }

    private boolean shouldReturn() {
        Vec3 delta = this.m_20184_();
        return Math.abs(delta.f_82479_) < 0.16 && Math.abs(delta.f_82480_) < 0.16 && Math.abs(delta.f_82481_) < 0.16;
    }

    private void updateReturning() {
        if (this.shouldReturn()) {
            this.setReturning(true);
        }
    }

    private boolean shouldDrop(Vec3 targetPos) {
        Entity owner = this.m_19749_();
        return owner != null && this.m_20182_().m_82557_(targetPos) < 5.0;
    }

    private void scaleDelta(double factor) {
        this.m_20256_(MathUtil.clamp(this.m_20184_().m_82542_(factor, factor, factor), -2.0, 2.0));
    }

    private void drop() {
        if (!this.f_19853_.f_46443_) {
            this.m_19983_(this.m_7846_());
        }
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_RETURNING, (Object)false);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")));
        this.setReturning(tag.m_128471_("returning"));
        this.age = tag.m_128451_("age");
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Item", (Tag)this.m_7846_().m_41739_(new CompoundTag()));
        tag.m_128379_("returning", this.isReturning());
        tag.m_128405_("age", this.age);
    }

    protected Item getDefaultItem() {
        return (Item)BRItems.BANANARANG.get();
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setItem(ItemStack stack) {
        if (!stack.m_150930_(this.getDefaultItem()) || stack.m_41782_() || stack.m_41613_() > 0) {
            this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)stack.m_41777_());
            this.setUpgrades(stack);
        }
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RETURNING);
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(DATA_RETURNING, (Object)returning);
    }
}

