/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.common.item;

import com.bonker.bananarangs.client.ClientUtil;
import com.bonker.bananarangs.client.renderer.BananarangBEWLR;
import com.bonker.bananarangs.common.BRSounds;
import com.bonker.bananarangs.common.entity.BananarangEntity;
import com.bonker.bananarangs.common.item.UpgradeItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class BananarangItem
extends Item {
    public BananarangItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            BananarangEntity.shootFromEntity((ServerLevel)level, (LivingEntity)player, (ItemStack)Util.m_137469_((Object)stack.m_41777_(), stack1 -> stack1.m_41764_(1)));
            if (!player.m_36335_().m_41519_(stack.m_41720_()) && BananarangItem.hasUpgrade(stack, "explosive")) {
                player.m_36335_().m_41524_(stack.m_41720_(), 40);
            }
            stack.m_41774_(1);
        }
        level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BRSounds.BANANARANG_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        ClientUtil.addBananarangTooltip(stack, tooltip);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(BananarangBEWLR.EXTENSION());
    }

    public boolean m_142522_(ItemStack pStack) {
        return BananarangItem.getAttachedItem(pStack).m_150947_();
    }

    public int m_142158_(ItemStack pStack) {
        return BananarangItem.getAttachedItem(pStack).m_150948_();
    }

    public int m_142159_(ItemStack pStack) {
        return BananarangItem.getAttachedItem(pStack).m_150949_();
    }

    public static String getUpgradeInSlot(ItemStack stack, int slot) {
        if (slot != 0 && slot != 1) {
            return "";
        }
        return stack.m_41784_().m_128461_("slot" + slot);
    }

    public static void setUpgradeInSlot(ItemStack stack, int slot, String upgrade) {
        if (slot != 0 && slot != 1) {
            return;
        }
        if (upgrade.equals("") || UpgradeItem.isValid(upgrade)) {
            stack.m_41784_().m_128359_("slot" + slot, upgrade);
        }
    }

    public static boolean hasUpgrade(ItemStack stack, String upgrade) {
        if (!UpgradeItem.isValid(upgrade)) {
            return false;
        }
        if (upgrade.equals(BananarangItem.getUpgradeInSlot(stack, 0))) {
            return true;
        }
        return upgrade.equals(BananarangItem.getUpgradeInSlot(stack, 1));
    }

    public static boolean isUpgraded(ItemStack stack) {
        return !BananarangItem.getUpgradeInSlot(stack, 0).equals("") || !BananarangItem.getUpgradeInSlot(stack, 1).equals("");
    }

    public static ItemStack getAttachedItem(ItemStack bananarang) {
        return ItemStack.m_41712_((CompoundTag)bananarang.m_41784_().m_128469_("attachedItem"));
    }

    public static void setAttachedItem(ItemStack bananarang, ItemStack stack) {
        bananarang.m_41784_().m_128365_("attachedItem", (Tag)stack.serializeNBT());
    }

    public static boolean hasPickaxe(ItemStack bananarang) {
        return BananarangItem.getAttachedItem(bananarang).m_41720_() instanceof PickaxeItem && BananarangItem.hasUpgrade(bananarang, "pickaxe");
    }

    public static int pickaxeEfficiency(ItemStack bananarang) {
        return BananarangItem.getAttachedItem(bananarang).getEnchantmentLevel(Enchantments.f_44984_);
    }

    public static int damageUpgrade(ItemStack bananarang) {
        if (BananarangItem.hasUpgrade(bananarang, "damage_1")) {
            return 1;
        }
        if (BananarangItem.hasUpgrade(bananarang, "damage_2")) {
            return 2;
        }
        if (BananarangItem.hasUpgrade(bananarang, "damage_3")) {
            return 3;
        }
        return 0;
    }

    public static double powerUpgrade(ItemStack bananarang) {
        if (BananarangItem.hasUpgrade(bananarang, "power_1")) {
            return 1.0;
        }
        if (BananarangItem.hasUpgrade(bananarang, "power_2")) {
            return 2.0;
        }
        if (BananarangItem.hasUpgrade(bananarang, "power_3")) {
            return 3.0;
        }
        return 0.0;
    }
}

