/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.common.item;

import com.bonker.bananarangs.client.ClientUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends Item {
    private final String upgrade;
    private final List<String> incompatibleUpgrades;
    public static final List<String> DAMAGE_UPGRADES = List.of("damage_1", "damage_2", "damage_3");
    public static final List<String> CENTER_UPGRADES = List.of("fling", "piercing");
    public static final List<String> POWER_UPGRADES = List.of("power_1", "power_2", "power_3");
    public static final List<String> EDGE_UPGRADES = List.of("flaming", "sticky");
    public static final List<String> NONE = List.of();
    public static final Map<String, UpgradeItem> UPGRADE_MAP = new HashMap<String, UpgradeItem>();
    public static final Map<String, ResourceLocation> UPGRADE_MODEL_MAP = new HashMap<String, ResourceLocation>();

    public UpgradeItem(Item.Properties properties, String upgrade, List<String> incompatibleUpgrades) {
        super(properties.m_41487_(1));
        this.upgrade = upgrade;
        this.incompatibleUpgrades = incompatibleUpgrades;
        UPGRADE_MAP.put(upgrade, this);
        UPGRADE_MODEL_MAP.put(upgrade, new ResourceLocation("bananarangs", "item/upgrades/" + upgrade));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pIsAdvanced) {
        ClientUtil.addUpgradeItemTooltip(pStack, pTooltip);
    }

    public String getUpgrade() {
        return this.upgrade;
    }

    public boolean isCompatible(String upgrade) {
        return !upgrade.equals(this.upgrade) && !this.incompatibleUpgrades.contains(upgrade);
    }

    public static boolean isValid(String upgrade) {
        return UPGRADE_MODEL_MAP.containsKey(upgrade);
    }

    public static class AttachItemUpgrade
    extends UpgradeItem {
        private final Predicate<ItemStack> validItemPredicate;

        public AttachItemUpgrade(Item.Properties properties, String upgrade, List<String> incompatibleUpgrades, Predicate<ItemStack> validItemPredicate) {
            super(properties, upgrade, incompatibleUpgrades);
            this.validItemPredicate = validItemPredicate;
        }

        public boolean isValidItem(ItemStack stack) {
            return this.validItemPredicate.test(stack);
        }
    }
}

