/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.menu;

import com.bonker.bananarangs.common.BRSounds;
import com.bonker.bananarangs.common.block.BRBlocks;
import com.bonker.bananarangs.common.item.BRItems;
import com.bonker.bananarangs.common.item.BananarangItem;
import com.bonker.bananarangs.common.item.UpgradeItem;
import com.bonker.bananarangs.menu.BRMenus;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BananarangAnvilMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int ANVIL_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int ANVIL_INVENTORY_SLOT_COUNT = 4;
    private static final List<Integer> UPGRADE_SLOT_INDEXES = List.of(Integer.valueOf(36), Integer.valueOf(37));
    private static final int BANANARANG_SLOT_INDEX = 38;
    private static final int ITEM_SLOT_INDEX = 39;
    private final ContainerLevelAccess access;
    private final Container container = new SimpleContainer(40);
    private boolean changedNBT = false;

    public static BananarangAnvilMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        return new BananarangAnvilMenu(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public BananarangAnvilMenu(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)BRMenus.BANANARANG_ANVIL.get(), containerId);
        this.access = access;
        this.createInventorySlots(inventory);
        this.createUpgradeSlot(0, 33, 25);
        this.createUpgradeSlot(1, 127, 25);
        this.createBananarangSlot(80, 29);
        this.createItemSlot(33, 52);
    }

    public void m_6877_(Player pPlayer) {
        this.clearSlots();
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.container));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 40) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60713_((Block)BRBlocks.BANANARANG_ANVIL.get()) && pPlayer.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private void createBananarangSlot(int x, int y) {
        this.m_38897_(new Slot(this.container, 38, x, y){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)BRItems.BANANARANG.get());
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                BananarangAnvilMenu.this.onSetBananarang(stack);
            }
        });
    }

    private void createUpgradeSlot(final int slot, int x, int y) {
        this.m_38897_(new Slot(this.container, UPGRADE_SLOT_INDEXES.get(slot), x, y){

            public boolean m_5857_(ItemStack stack) {
                return BananarangAnvilMenu.this.hasBananarang() && stack.m_41720_() instanceof UpgradeItem && BananarangAnvilMenu.this.canPlaceUpgrade(slot, stack);
            }

            public boolean m_8010_(Player player) {
                return BananarangAnvilMenu.this.getItemUpgradeSlot() != slot || this.f_40218_.m_8020_(39).m_41619_();
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                BananarangAnvilMenu.this.onSetUpgrade(slot, stack);
            }

            public boolean m_6659_() {
                return super.m_6659_() && BananarangAnvilMenu.this.hasBananarang();
            }
        });
    }

    private void createItemSlot(int x, int y) {
        this.m_38897_(new Slot(this.container, 39, x, y){

            public boolean m_5857_(ItemStack stack) {
                if (!BananarangAnvilMenu.this.hasBananarang()) {
                    return false;
                }
                int itemUpgradeSlot = BananarangAnvilMenu.this.getItemUpgradeSlot();
                if (itemUpgradeSlot == -1) {
                    return false;
                }
                Item item = this.f_40218_.m_8020_(UPGRADE_SLOT_INDEXES.get(itemUpgradeSlot).intValue()).m_41720_();
                if (item instanceof UpgradeItem.AttachItemUpgrade) {
                    UpgradeItem.AttachItemUpgrade attachItemUpgrade = (UpgradeItem.AttachItemUpgrade)item;
                    return attachItemUpgrade.isValidItem(stack);
                }
                return true;
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                BananarangAnvilMenu.this.onSetItem(stack);
            }

            public boolean m_6659_() {
                int slot = BananarangAnvilMenu.this.getItemUpgradeSlot();
                if (slot == 0) {
                    this.f_40220_ = 33;
                }
                if (slot == 1) {
                    this.f_40220_ = 127;
                }
                return super.m_6659_() && slot != -1;
            }
        });
    }

    boolean hasBananarang() {
        return this.container.m_8020_(38).m_150930_((Item)BRItems.BANANARANG.get());
    }

    int getItemUpgradeSlot() {
        if (this.container.m_8020_(UPGRADE_SLOT_INDEXES.get(0).intValue()).m_41720_() instanceof UpgradeItem.AttachItemUpgrade) {
            return 0;
        }
        if (this.container.m_8020_(UPGRADE_SLOT_INDEXES.get(1).intValue()).m_41720_() instanceof UpgradeItem.AttachItemUpgrade) {
            return 1;
        }
        return -1;
    }

    private boolean canPlaceUpgrade(int index, ItemStack upgrade) {
        UpgradeItem otherUpgradeItem;
        Item item;
        block3: {
            block2: {
                ItemStack otherUpgrade = this.container.m_8020_(UPGRADE_SLOT_INDEXES.get(index == 0 ? 1 : 0).intValue());
                if (otherUpgrade.m_41619_() || !((item = otherUpgrade.m_41720_()) instanceof UpgradeItem)) break block2;
                otherUpgradeItem = (UpgradeItem)item;
                item = upgrade.m_41720_();
                if (item instanceof UpgradeItem) break block3;
            }
            return true;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        return otherUpgradeItem.isCompatible(upgradeItem.getUpgrade()) && upgradeItem.isCompatible(otherUpgradeItem.getUpgrade());
    }

    private void onSetBananarang(ItemStack stack) {
        if (stack.m_41619_()) {
            this.clearSlots();
            if (this.changedNBT) {
                this.playSound((SoundEvent)BRSounds.BANANARANG_SLOT_TAKE.get(), 1.1f);
            }
            this.changedNBT = false;
        } else {
            UpgradeItem slot0 = UpgradeItem.UPGRADE_MAP.get(BananarangItem.getUpgradeInSlot(stack, 0));
            UpgradeItem slot1 = UpgradeItem.UPGRADE_MAP.get(BananarangItem.getUpgradeInSlot(stack, 1));
            if (slot0 != null) {
                this.container.m_6836_(UPGRADE_SLOT_INDEXES.get(0).intValue(), new ItemStack((ItemLike)slot0));
            }
            if (slot1 != null) {
                this.container.m_6836_(UPGRADE_SLOT_INDEXES.get(1).intValue(), new ItemStack((ItemLike)slot1));
            }
            this.container.m_6836_(39, BananarangItem.getAttachedItem(stack));
            this.playSound((SoundEvent)BRSounds.BANANARANG_SLOT_PLACE.get(), 0.7f);
        }
    }

    private void clearSlots() {
        this.container.m_6836_(UPGRADE_SLOT_INDEXES.get(0).intValue(), ItemStack.f_41583_);
        this.container.m_6836_(UPGRADE_SLOT_INDEXES.get(1).intValue(), ItemStack.f_41583_);
        this.container.m_6836_(39, ItemStack.f_41583_);
    }

    private void onSetUpgrade(int slot, ItemStack stack) {
        BananarangItem.setUpgradeInSlot(this.container.m_8020_(38), slot, stack.m_41619_() ? "" : ((UpgradeItem)stack.m_41720_()).getUpgrade());
        this.playSound((SoundEvent)BRSounds.UPGRADE_SLOT_INTERACT.get(), stack.m_41619_() ? 1.0f : 0.8f);
        this.changedNBT = true;
    }

    private void onSetItem(ItemStack stack) {
        BananarangItem.setAttachedItem(this.container.m_8020_(38), stack);
        this.playSound((SoundEvent)BRSounds.ITEM_SLOT_INTERACT.get(), stack.m_41619_() ? 1.2f : 0.8f);
        this.changedNBT = true;
    }

    private void createInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    private void playSound(SoundEvent sound, float pitch) {
        this.access.m_39292_((level, pos) -> level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, pitch));
    }
}

