/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.bananarangs.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static double clamp(double value, double max) {
        return MathUtil.clamp(value, value, max);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(min, value), max);
    }

    public static Vec3 clamp(Vec3 values, double min, double max) {
        return new Vec3(MathUtil.clamp(values.f_82479_, min, max), MathUtil.clamp(values.f_82480_, min, max), MathUtil.clamp(values.f_82481_, min, max));
    }

    public static Iterable<BlockPos> insideHitbox(AABB hitbox) {
        return BlockPos.m_121976_((int)Mth.m_14107_((double)hitbox.f_82288_), (int)Mth.m_14107_((double)hitbox.f_82289_), (int)Mth.m_14107_((double)hitbox.f_82290_), (int)Mth.m_14107_((double)hitbox.f_82291_), (int)Mth.m_14107_((double)hitbox.f_82292_), (int)Mth.m_14107_((double)hitbox.f_82293_));
    }

    public static List<BlockPos> insideHitboxSorted(AABB hitbox, Vec3 point) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos pos : MathUtil.insideHitbox(hitbox)) {
            list.add(pos);
        }
        return MathUtil.sortByDistance(list, point);
    }

    public static List<BlockPos> sortByDistance(List<BlockPos> toSort, Vec3 point) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(toSort);
        MathUtil.bubbleSort(list, pos -> point.m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        return list;
    }

    public static <T> void bubbleSort(List<T> list, Function<T, Double> valueGetter) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 1; j < size - i; ++j) {
                if (!(valueGetter.apply(list.get(j - 1)) > valueGetter.apply(list.get(j)))) continue;
                T temp = list.get(j - 1);
                list.set(j - 1, list.get(j));
                list.set(j, temp);
            }
        }
    }
}

