/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betterpingdisplay", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterPingDisplayConfig {
    public static String textColor;
    public static String textFormatString;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void bake() {
        textColor = (String)BetterPingDisplayConfig.CLIENT.textColor.get();
        textFormatString = (String)BetterPingDisplayConfig.CLIENT.textFormatString.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            BetterPingDisplayConfig.bake();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<String> textColor;
        public final ForgeConfigSpec.ConfigValue<String> textFormatString;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.textColor = builder.comment("The color of the ping display text, written in hex format. Default: #A0A0A0").define("textColor", (Object)"#A0A0A0");
            this.textFormatString = builder.comment(new String[]{"Customize the display text of the ping display", "Must contain a '%d', which will be replaced with the ping number", "Example: '%dms' will transform into '123ms' if the player's ping is 123", "Default: %dms"}).define("textFormatString", (Object)"%dms");
        }
    }
}

