/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.client;

import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.vladmarica.betterpingdisplay.BetterPingDisplayConfig;
import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import com.vladmarica.betterpingdisplay.client.PlayerComparator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.overlay.PlayerTabOverlayGui;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderPingHandler {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private static final int DEFAULT_PING_TEXT_COLOR = 0xA0A0A0;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private static final int PING_TEXT_RENDER_OFFSET = -13;
    private static final int PLAYER_SLOT_EXTRA_WIDTH = 45;
    private static final int PLAYER_ICON_WIDTH = 9;
    private boolean configLoaded = false;
    private int pingTextColor;
    private String pingTextFormat;

    public void loadConfig() {
        if (BetterPingDisplayConfig.textColor.startsWith("#")) {
            try {
                this.pingTextColor = Integer.parseInt(BetterPingDisplayConfig.textColor.substring(1), 16);
            }
            catch (NumberFormatException ex) {
                BetterPingDisplayMod.logger().error("Config option 'pingTextColor' is invalid - it must be a hex color code");
                this.pingTextColor = 0xA0A0A0;
            }
        } else {
            this.pingTextColor = 0xA0A0A0;
        }
        if (BetterPingDisplayConfig.textFormatString.contains("%d")) {
            this.pingTextFormat = BetterPingDisplayConfig.textFormatString;
        } else {
            this.pingTextFormat = DEFAULT_PING_TEXT_FORMAT;
            BetterPingDisplayMod.logger().error("Config option 'textFormatString' is invalid - it needs to contain %d");
        }
    }

    @SubscribeEvent
    public void onRenderGuiPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            if (!this.configLoaded) {
                this.loadConfig();
                this.configLoaded = true;
            }
            this.renderPlayerList(Minecraft.func_71410_x());
        }
    }

    private void renderPlayerList(Minecraft mc) {
        boolean displayPlayerIcons;
        int playerCount;
        PlayerTabOverlayGui playerListGui = mc.field_71456_v.func_175181_h();
        int width = mc.func_228018_at_().func_198107_o();
        Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
        ScoreObjective objective = scoreboard.func_96539_a(0);
        ClientPlayNetHandler handler = mc.field_71439_g.field_71174_a;
        List playerList = ENTRY_ORDERING.sortedCopy((Iterable)handler.func_175106_d());
        int i = 0;
        int j = 0;
        for (NetworkPlayerInfo playerInfo : playerList) {
            int nameStringWidth = mc.field_71466_p.func_78256_a(playerListGui.func_200262_a(playerInfo).func_150254_d());
            i = Math.max(i, nameStringWidth);
            if (objective == null || objective.func_199865_f() == ScoreCriteria.RenderType.HEARTS) continue;
            nameStringWidth = mc.field_71466_p.func_78256_a(" " + scoreboard.func_96529_a(playerInfo.func_178845_a().getName(), objective).func_96652_c());
            j = Math.max(j, nameStringWidth);
        }
        playerList = playerList.subList(0, Math.min(playerList.size(), 80));
        int j4 = playerCount = playerList.size();
        int k4 = 1;
        while (j4 > 20) {
            j4 = (playerCount + ++k4 - 1) / k4;
        }
        boolean bl = displayPlayerIcons = mc.func_71387_A() || mc.func_147114_u().func_147298_b().func_179292_f();
        int l = objective != null ? (objective.func_199865_f() == ScoreCriteria.RenderType.HEARTS ? 90 : j) : 0;
        int i1 = Math.min(k4 * ((displayPlayerIcons ? 9 : 0) + i + l + 13 + 45), width - 50) / k4;
        int j1 = width / 2 - (i1 * k4 + (k4 - 1) * 5) / 2;
        int k1 = 10;
        int l1 = i1 * k4 + (k4 - 1) * 5;
        List list1 = null;
        if (playerListGui.field_175256_i != null) {
            list1 = mc.field_71466_p.func_78271_c(playerListGui.field_175256_i.func_150254_d(), width - 50);
            for (Iterator s : list1) {
                l1 = Math.max(l1, mc.field_71466_p.func_78256_a((String)((Object)s)));
            }
        }
        List list2 = null;
        if (playerListGui.field_175255_h != null) {
            list2 = mc.field_71466_p.func_78271_c(playerListGui.field_175255_h.func_150254_d(), width - 50);
            for (String s1 : list2) {
                l1 = Math.max(l1, mc.field_71466_p.func_78256_a(s1));
            }
        }
        if (list1 != null) {
            AbstractGui.fill((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list1.size() * 9), (int)Integer.MIN_VALUE);
            for (String s2 : list1) {
                int i2 = mc.field_71466_p.func_78256_a(s2);
                mc.field_71466_p.func_175063_a(s2, (float)(width / 2 - i2 / 2), (float)k1, -1);
                k1 += 9;
            }
            ++k1;
        }
        AbstractGui.fill((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + j4 * 9), (int)Integer.MIN_VALUE);
        int l4 = mc.field_71474_y.func_216839_a(0x20FFFFFF);
        for (int playerIndex = 0; playerIndex < playerCount; ++playerIndex) {
            int l5;
            int i6;
            int j5 = playerIndex / j4;
            int j2 = playerIndex % j4;
            int k2 = j1 + j5 * i1 + j5 * 5;
            int l2 = k1 + j2 * 9;
            AbstractGui.fill((int)k2, (int)l2, (int)(k2 + i1), (int)(l2 + 8), (int)l4);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (playerIndex >= playerList.size()) continue;
            NetworkPlayerInfo player = (NetworkPlayerInfo)playerList.get(playerIndex);
            GameProfile gameprofile = player.func_178845_a();
            if (displayPlayerIcons) {
                PlayerEntity playerentity = mc.field_71441_e.func_217371_b(gameprofile.getId());
                boolean flag1 = playerentity != null && playerentity.func_175148_a(PlayerModelPart.CAPE) && ("Dinnerbone".equals(gameprofile.getName()) || "Grumm".equals(gameprofile.getName()));
                mc.func_110434_K().func_110577_a(player.func_178837_g());
                int i3 = 8 + (flag1 ? 8 : 0);
                int j3 = 8 * (flag1 ? -1 : 1);
                AbstractGui.blit((int)k2, (int)l2, (int)8, (int)8, (float)8.0f, (float)i3, (int)8, (int)j3, (int)64, (int)64);
                if (playerentity != null && playerentity.func_175148_a(PlayerModelPart.HAT)) {
                    int k3 = 8 + (flag1 ? 8 : 0);
                    int l3 = 8 * (flag1 ? -1 : 1);
                    AbstractGui.blit((int)k2, (int)l2, (int)8, (int)8, (float)40.0f, (float)k3, (int)8, (int)l3, (int)64, (int)64);
                }
                k2 += 9;
            }
            String s4 = playerListGui.func_200262_a(player).func_150254_d();
            if (player.func_178848_b() == GameType.SPECTATOR) {
                mc.field_71466_p.func_175063_a(TextFormatting.ITALIC + s4, (float)k2, (float)l2, -1862270977);
            } else {
                mc.field_71466_p.func_175063_a(s4, (float)k2, (float)l2, -1);
            }
            if (objective != null && player.func_178848_b() != GameType.SPECTATOR && (i6 = (l5 = k2 + i + 1) + l) - l5 > 5) {
                playerListGui.func_175247_a(objective, l2, gameprofile.getName(), l5, i6, player);
            }
            String pingString = String.format(this.pingTextFormat, player.func_178853_c());
            int pingStringWidth = mc.field_71466_p.func_78256_a(pingString);
            mc.field_71466_p.func_175063_a(pingString, (float)i1 + (float)k2 - (float)pingStringWidth + -13.0f - (float)(displayPlayerIcons ? 9 : 0), (float)l2, this.pingTextColor);
            playerListGui.func_175245_a(i1, k2 - (displayPlayerIcons ? 9 : 0), l2, player);
        }
        if (list2 != null) {
            k1 = k1 + j4 * 9 + 1;
            AbstractGui.fill((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list2.size() * 9), (int)Integer.MIN_VALUE);
            for (String s3 : list2) {
                int k5 = mc.field_71466_p.func_78256_a(s3);
                mc.field_71466_p.func_175063_a(s3, (float)(width / 2 - k5 / 2), (float)k1, -1);
                k1 += 9;
            }
        }
    }
}

