/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.AngleUtils;
import io.socol.betterthirdperson.TickPhase;
import io.socol.betterthirdperson.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.adapter.IPlayerAdapter;
import io.socol.betterthirdperson.adapter.IPlayerPosition;

public class CustomCamera {
    private float cameraYaw;
    private float playerYaw;
    private IPlayerPosition lastTickPlayerPos;
    private float prevInputYaw = 0.0f;
    private float inputYaw = 0.0f;
    private boolean hasMovementInputs = false;

    public CustomCamera(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
        this.lastTickPlayerPos = player.getPosition();
    }

    public void handleInputs(IMovementInputAdapter input) {
        this.prevInputYaw = this.inputYaw;
        boolean leftKeyDown = input.isLeftKeyDown();
        boolean rightKeyDown = input.isRightKeyDown();
        boolean forwardKeyDown = input.isForwardKeyDown();
        boolean backKeyDown = input.isBackKeyDown();
        if (leftKeyDown || rightKeyDown || forwardKeyDown || backKeyDown) {
            if (forwardKeyDown != backKeyDown) {
                float f = this.inputYaw = forwardKeyDown ? 0.0f : -180.0f;
                if (leftKeyDown != rightKeyDown) {
                    this.inputYaw += (leftKeyDown ? -45.0f : 45.0f) * (float)(forwardKeyDown ? 1 : -1);
                }
            } else if (leftKeyDown != rightKeyDown) {
                this.inputYaw = leftKeyDown ? -90.0f : 90.0f;
            }
            float moveImpulse = Math.max(Math.abs(input.getMoveForward()), Math.abs(input.getMoveStrafe()));
            input.setMoveForward(moveImpulse);
            input.setMoveStrafe(0.0f);
            input.setLeftKeyDown(false);
            input.setRightKeyDown(false);
            input.setBackKeyDown(false);
            input.setForwardKeyDown(true);
            this.hasMovementInputs = true;
        } else {
            this.hasMovementInputs = false;
        }
    }

    public void setup(IPlayerAdapter player, float partialTicks) {
        if (this.playerYaw != player.getRotationYaw()) {
            this.cameraYaw += player.getRotationYaw() - this.playerYaw;
        }
        if (this.hasMovementInputs) {
            this.playerYaw = this.cameraYaw + AngleUtils.smoothAngle(partialTicks, this.prevInputYaw, this.inputYaw);
        }
        player.setRotationYaw(this.playerYaw);
    }

    public float getYawDelta() {
        return this.cameraYaw - this.playerYaw;
    }

    public void checkPosition(TickPhase phase, IPlayerAdapter player) {
        IPlayerPosition currentPos = player.getPosition();
        if (phase == TickPhase.START) {
            if (!this.lastTickPlayerPos.equals(currentPos)) {
                this.resetToPlayerView(player);
            }
        } else {
            this.lastTickPlayerPos = currentPos;
        }
    }

    private void resetToPlayerView(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
    }
}

