/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.CustomCamera;
import io.socol.betterthirdperson.TickPhase;
import io.socol.betterthirdperson.adapter.IClientAdapter;
import io.socol.betterthirdperson.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.adapter.IPlayerAdapter;

public class CustomCameraManager {
    private final IClientAdapter client;
    private CustomCamera customCamera;

    public CustomCameraManager(IClientAdapter client) {
        this.client = client;
    }

    public CustomCamera getCustomCamera() {
        return this.customCamera;
    }

    public boolean hasCustomCamera() {
        return this.customCamera != null;
    }

    private boolean mustHaveCustomCamera(IPlayerAdapter player) {
        boolean customCameraInitialized;
        boolean mustHaveCustomCamera = !this.client.isFirstPerson() && !this.client.isCameraMirrored() && !player.isPassenger();
        boolean bl = customCameraInitialized = this.customCamera != null;
        if (mustHaveCustomCamera != customCameraInitialized) {
            this.customCamera = mustHaveCustomCamera ? new CustomCamera(player) : null;
        }
        return mustHaveCustomCamera;
    }

    public void onPlayerTick(IPlayerAdapter player, TickPhase phase) {
        if (this.hasCustomCamera()) {
            this.customCamera.checkPosition(phase, player);
        }
    }

    public void onInputs(IPlayerAdapter player, IMovementInputAdapter inputs) {
        if (this.mustHaveCustomCamera(player)) {
            this.customCamera.handleInputs(inputs);
        }
    }

    public void onRenderTickStart(IPlayerAdapter player, float partialTicks) {
        if (!this.mustHaveCustomCamera(player)) {
            return;
        }
        this.customCamera.setup(player, partialTicks);
    }
}

