/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CustomCameraConfigImpl
implements CustomCameraConfig {
    private final ForgeConfigSpec config;
    private final ForgeConfigSpec.BooleanValue aimOnInteract;
    private final ForgeConfigSpec.IntValue flickTimeout;
    private final ForgeConfigSpec.IntValue followYaw;
    private final ForgeConfigSpec.BooleanValue freeCameraDuringElytraFlight;

    public CustomCameraConfigImpl() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CustomCameraConfig def = DefaultCustomCameraConfig.INSTANCE;
        this.aimOnInteract = builder.comment("Align player to camera on left & right clicks (delayed by Flick Timeout)").define("aimPlayerOnInteract", def.shouldAimPlayerOnInteract());
        this.flickTimeout = builder.comment("Delay in ticks between moments when player can flick towards the target in third person").defineInRange("flickTimeout", def.getFlickTimeout(), 1, 20);
        this.followYaw = builder.comment("Angle in degrees within the player will slightly follow camera rotation").defineInRange("followYaw", def.getFollowYaw(), 0, 90);
        this.freeCameraDuringElytraFlight = builder.comment("Does camera should rotate freely during elytra flight").define("freeCameraDuringElytraFlight", def.hasFreeCameraDuringElytraFlight());
        this.config = builder.build();
    }

    public static CustomCameraConfig create() {
        CustomCameraConfigImpl configImpl = new CustomCameraConfigImpl();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configImpl.config);
        return configImpl;
    }

    @Override
    public boolean shouldAimPlayerOnInteract() {
        return (Boolean)this.aimOnInteract.get();
    }

    @Override
    public int getFlickTimeout() {
        return (Integer)this.flickTimeout.get();
    }

    @Override
    public int getFollowYaw() {
        return (Integer)this.followYaw.get();
    }

    @Override
    public boolean hasFreeCameraDuringElytraFlight() {
        return (Boolean)this.freeCameraDuringElytraFlight.get();
    }
}

