/*
 * Decompiled with CFR 0.152.
 */
package com.fhannenheim.boostboots.compat;

import com.fhannenheim.boostboots.init.Items;
import com.fhannenheim.boostboots.model.BootModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    private static final ResourceLocation BOOT_TEXTURE = new ResourceLocation("boostboots", "textures/armor/boots.png");

    public static ICapabilityProvider initCapabilities() {
        final ICurio curio = new ICurio(){
            private Object model;

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.field_70170_p.func_184133_a(null, new BlockPos(livingEntity.func_213303_ch()), SoundEvents.field_191258_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return ICurio.DropRule.DEFAULT;
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (!(this.model instanceof BootModel)) {
                    this.model = new BootModel();
                }
                BootModel boots = (BootModel)((Object)this.model);
                boots.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(boots.func_228282_a_(BOOT_TEXTURE));
                boots.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getBoostCurio(PlayerEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)Items.BOOST_BOOTS.get(), (LivingEntity)player);
    }
}

