/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.data.bounty;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import ejektaflex.bountiful.BountifulConfig;
import ejektaflex.bountiful.BountifulMod;
import ejektaflex.bountiful.data.bounty.BountyEntry;
import ejektaflex.bountiful.data.bounty.BountyProgress;
import ejektaflex.bountiful.data.bounty.IBountyObjective;
import ejektaflex.bountiful.data.bounty.IBountyReward;
import ejektaflex.bountiful.data.bounty.enums.BountyType;
import ejektaflex.bountiful.ext.ExtMiscKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u001e\u0010\u0005\u001a\u00020\u00068\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lejektaflex/bountiful/data/bounty/BountyEntryExperience;", "Lejektaflex/bountiful/data/bounty/BountyEntry;", "Lejektaflex/bountiful/data/bounty/IBountyObjective;", "Lejektaflex/bountiful/data/bounty/IBountyReward;", "()V", "bType", "", "getBType", "()Ljava/lang/String;", "setBType", "(Ljava/lang/String;)V", "calculatedWorth", "", "getCalculatedWorth", "()I", "formattedName", "Lnet/minecraft/util/text/IFormattableTextComponent;", "getFormattedName", "()Lnet/minecraft/util/text/IFormattableTextComponent;", "dropXpOnPlayer", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "amt", "reward", "tooltipObjective", "Lnet/minecraft/util/text/ITextComponent;", "progress", "Lejektaflex/bountiful/data/bounty/BountyProgress;", "tooltipReward", "Bountiful"})
public final class BountyEntryExperience
extends BountyEntry
implements IBountyObjective,
IBountyReward {
    @Expose
    @SerializedName(value="type")
    @NotNull
    private String bType = BountyType.Experience.getId();

    @Override
    @NotNull
    public String getBType() {
        return this.bType;
    }

    @Override
    public void setBType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bType = string;
    }

    @Override
    public int getCalculatedWorth() {
        return this.getUnitWorth() * this.getAmount();
    }

    @Override
    @NotNull
    public IFormattableTextComponent getFormattedName() {
        IFormattableTextComponent iFormattableTextComponent;
        switch (this.getContent()) {
            case "levels": {
                iFormattableTextComponent = (IFormattableTextComponent)new TranslationTextComponent("bountiful.bounty.type.experience.levels");
                break;
            }
            case "points": {
                iFormattableTextComponent = (IFormattableTextComponent)new TranslationTextComponent("bountiful.bounty.type.experience.points");
                break;
            }
            default: {
                iFormattableTextComponent = (IFormattableTextComponent)new StringTextComponent("??? (xp)");
            }
        }
        return iFormattableTextComponent;
    }

    @Override
    @NotNull
    public ITextComponent tooltipReward() {
        IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(String.valueOf(this.getAmount()) + "x ").func_240699_a_(TextFormatting.WHITE);
        Intrinsics.checkNotNullExpressionValue((Object)iFormattableTextComponent, (String)"StringTextComponent(amou\u2026yle(TextFormatting.WHITE)");
        ITextComponent iTextComponent = (ITextComponent)iFormattableTextComponent;
        IFormattableTextComponent iFormattableTextComponent2 = this.getFormattedName().func_240699_a_(TextFormatting.AQUA);
        Intrinsics.checkNotNullExpressionValue((Object)iFormattableTextComponent2, (String)"formattedName.mergeStyle(TextFormatting.AQUA)");
        return ExtMiscKt.withSibling(iTextComponent, (ITextComponent)iFormattableTextComponent2);
    }

    private final void dropXpOnPlayer(PlayerEntity player, int amt) {
        int dropAmount;
        for (int dropsLeft = amt; dropsLeft > 0; dropsLeft -= dropAmount) {
            dropAmount = ExperienceOrbEntity.func_70527_a((int)dropsLeft);
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), dropAmount));
        }
    }

    @Override
    public void reward(@NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        switch (this.getContent()) {
            case "levels": {
                player.func_82242_a(this.getAmount());
                break;
            }
            case "points": {
                Object object = BountifulConfig.Companion.getSERVER().getDoXpDrop().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"BountifulConfig.SERVER.doXpDrop.get()");
                if (((Boolean)object).booleanValue()) {
                    this.dropXpOnPlayer(player, this.getAmount());
                    break;
                }
                player.func_195068_e(this.getAmount());
                break;
            }
            default: {
                BountifulMod.INSTANCE.getLogger().error("Experience reward tried to give '" + this.getContent() + "', which is invalid. Content must be 'points' or 'levels'");
            }
        }
    }

    @Override
    @NotNull
    public ITextComponent tooltipObjective(@NotNull BountyProgress progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(progress.getStringNums()).func_240699_a_(progress.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)iFormattableTextComponent, (String)"StringTextComponent(prog\u2026ergeStyle(progress.color)");
        return ExtMiscKt.withSibling((ITextComponent)iFormattableTextComponent, (ITextComponent)this.getFormattedName());
    }
}

