/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui.commands;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.network.packets.gui.DimensionTaskPacket;

public class GuiDimensionDeletion
extends GuiPregenBase {
    GuiScreen prev;
    SelectionList<Integer> dimensions = new SelectionList();

    public GuiDimensionDeletion(GuiScreen prev) {
        this.prev = prev;
        this.dimensions.addValues(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerButton(0, -40, 90, 80, 20, "Back");
        this.registerButton(1, -80, -50, 160, 20, "Dimension: " + this.getName());
        this.registerButton(2, 10, -20, 100, 20, "Delete Dimension!");
        this.registerButton(3, -100, -20, 100, 20, "Unload Dimension!");
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.func_147108_a(this.prev);
        } else if (id == 1) {
            if (GuiScreen.func_146272_n()) {
                this.dimensions.prev();
            } else {
                this.dimensions.next();
            }
            button.field_146126_j = "Dimension: " + this.getName();
        } else if (id == 2 || id == 3) {
            ChunkPregenerator.networking.sendPacketToServer(new DimensionTaskPacket(id == 3, this.dimensions.getValue()));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73866_w_();
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCenterText("Dimension Deletion", 0, -100, Color.WHITE.getRGB());
        this.drawCenterText("Dimensions have to be Unloaded to be deleted (except for the overworld)", 0, -80, Color.WHITE.getRGB());
        if (this.getIDButton(1).func_146115_a()) {
            this.drawListText(Arrays.asList("The Dimension that needs to be deleted"), mouseX, mouseY - 15);
        }
    }

    public String getName() {
        int dim = this.dimensions.getValue();
        return dim + " (" + GuiDimensionDeletion.getDimensionName(dim) + ")";
    }

    public static String getDimensionName(int id) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String s : DimensionManager.getProviderType((int)id).func_186065_b().replace("_", " ").split(" ")) {
                builder.append(StringUtils.capitalize((String)s)).append(" ");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

