/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.processor.ChunkLogger;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.retrogen.RetrogenHandler;
import pregenerator.impl.storage.TaskStorage;
import pregenerator.impl.structure.StructureManager;

public class CompleterHelper {
    public static final ICompleter GEN_TYPE = new ListCompleter("square", "circle");
    public static final ICompleter GEN_RADIUS_CHUNK = new ListCompleter("10", "25", "50", "75", "100", "200", "250", "500", "750", "1000");
    public static final ICompleter GEN_RADIUS_BLOCK = new ListCompleter("b10", "b25", "b50", "b75", "b100", "b200", "b250", "b500", "b750", "b1000");
    public static final ICompleter DIMENSION = new DimCompleter();
    public static final ICompleter GEN_PROCESS = new ListCompleter("TerrainOnly", "PostProcessingOnly", "BlockingPostProcessing", "Retrogen");
    public static final ICompleter GEN_DELAY = new ListCompleter("20", "200", "600", "1200", "3600", "6000", "12000");
    public static final ICompleter GEN_FILE = new FileCompleter();
    public static final ICompleter INFO_ADD = new AddCompleter();
    public static final ICompleter INFO_REMOVE = new RemoveCompleter();
    public static final ICompleter TASKLIST = new TaskCompleter();
    public static final ICompleter RETROGEN_ADD = new RetrogenAdd();
    public static final ICompleter RETROGEN_REMOVE = new RetrogenRemove();
    public static final ICompleter STRUCTURE_DIMENSION = new StructureDims();

    public static final ICompleter getStructures(int dim, boolean all) {
        return new StructureCompleter(dim, all);
    }

    public static class RetrogenRemove
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            return new ArrayList<String>(RetrogenHandler.INSTANCE.getActiveGenerators());
        }
    }

    public static class RetrogenAdd
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            return RetrogenHandler.INSTANCE.getInactiveGenerators();
        }
    }

    public static class StructureDims
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            return StructureManager.instance.getDims();
        }
    }

    public static class StructureCompleter
    implements ICompleter {
        int world;
        boolean all;

        public StructureCompleter(int world, boolean all) {
            this.world = world;
            this.all = all;
        }

        @Override
        public List<String> getCompleter() {
            List<String> list = StructureManager.instance.getAllTypes(this.world);
            if (this.all) {
                list.add(0, "All");
            }
            return list;
        }
    }

    public static class TaskCompleter
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            int count = TaskStorage.getStorage().getTaskCount();
            if (count == 0) {
                return new ArrayList<String>();
            }
            if (count == 1) {
                return Arrays.asList("first");
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("first");
            list.add("last");
            for (int i = 0; i < count; ++i) {
                list.add(i + "");
            }
            return list;
        }
    }

    public static class RemoveCompleter
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            ArrayList<String> list = new ArrayList<String>();
            for (ChunkLogger entry : ChunkProcessor.INSTANCE.getLoggerInfo()) {
                list.add(entry.getName());
            }
            return list;
        }
    }

    public static class AddCompleter
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            EnumSet<ChunkLogger> logger = EnumSet.allOf(ChunkLogger.class);
            logger.removeAll(ChunkProcessor.INSTANCE.getLoggerInfo());
            ArrayList<String> list = new ArrayList<String>();
            for (ChunkLogger entry : logger) {
                list.add(entry.getName());
            }
            return list;
        }
    }

    public static class FileCompleter
    implements ICompleter {
        @Override
        public List<String> getCompleter() {
            ArrayList<String> list = new ArrayList<String>();
            for (File file : ChunkPregenerator.pregeneratorFolder.listFiles()) {
                if (!file.getName().contains(".txt")) continue;
                list.add(file.getName());
            }
            return list;
        }
    }

    public static class ListCompleter
    implements ICompleter {
        public List<String> list = new ArrayList<String>();

        public ListCompleter(String ... s) {
            this.list.addAll(Arrays.asList(s));
        }

        @Override
        public List<String> getCompleter() {
            return this.list;
        }
    }

    public static class DimCompleter
    implements ICompleter {
        List<String> list = new ArrayList<String>();
        int lastDim = -1;

        @Override
        public List<String> getCompleter() {
            this.updateList();
            return this.list;
        }

        private void updateList() {
            Integer[] data = DimensionManager.getIDs();
            if (data.length != this.lastDim) {
                this.lastDim = data.length;
                this.list.clear();
                for (Integer entry : data) {
                    this.list.add(entry.toString());
                }
            }
        }
    }

    public static interface ICompleter {
        public List<String> getCompleter();
    }
}

