/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.LinkedList;

public class AverageCounter {
    LinkedList<Integer> allValues = new LinkedList();
    int limit;
    int count = 0;
    int average = 0;
    int last;

    public AverageCounter(int limit) {
        this.limit = limit;
    }

    public void addOne() {
        ++this.count;
    }

    public void addMore(int amount) {
        this.count += amount;
    }

    public void onFinished() {
        this.allValues.add(this.count);
        this.average += this.count;
        this.last = this.count;
        this.count = 0;
        if (this.allValues.size() > this.limit) {
            this.average -= this.allValues.removeFirst().intValue();
        }
    }

    public int getAverage() {
        return this.allValues.isEmpty() ? 0 : this.average / this.allValues.size();
    }

    public int getLast() {
        return this.last;
    }

    public void clear() {
        this.allValues.clear();
        this.count = 0;
        this.average = 0;
        this.last = 0;
    }
}

