/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.compot.item.crafting;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.crazysnailboy.mods.compot.CombinedPotions;
import net.crazysnailboy.mods.compot.common.config.ModConfiguration;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeCombinedPotions2
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static Item[] VALID_ITEMS = null;

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack tempStack = ItemStack.field_190927_a;
        if (VALID_ITEMS == null) {
            RecipeCombinedPotions2.buildValidItemsArray();
        }
        int potionEffects = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (!ArrayUtils.contains((Object[])VALID_ITEMS, (Object)item)) {
                return false;
            }
            if (tempStack.func_190926_b()) {
                tempStack = stack.func_77946_l();
            } else if (!this.canCombineItems(tempStack, stack)) {
                return false;
            }
            if (ModConfiguration.maxPotionEffects < 0 || (potionEffects += this.getEffectsFromStack(stack).size()) <= ModConfiguration.maxPotionEffects) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack outputStack = ItemStack.field_190927_a;
        if (RecipeCombinedPotions2.countSlotsNotEmpty((IInventory)inv) <= 1) {
            return outputStack;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (outputStack.func_190926_b()) {
                outputStack = this.getOutputStack(stack);
            }
            if (outputStack.func_190926_b()) {
                return outputStack;
            }
            effects.addAll(this.getEffectsFromStack(stack));
        }
        outputStack = PotionUtils.func_185184_a((ItemStack)outputStack, effects);
        outputStack.func_151001_c(I18n.func_74838_a((String)("item.combined_" + outputStack.func_77973_b().func_77658_a().substring(5) + ".name")));
        return outputStack;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    private static int countSlotsNotEmpty(IInventory inventory) {
        int result = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            ++result;
        }
        return result;
    }

    private static void buildValidItemsArray() {
        ArrayList<Object> valid_items = new ArrayList<Object>();
        valid_items.add(Items.field_151068_bn);
        valid_items.add(Items.field_185155_bH);
        valid_items.add(Items.field_185156_bI);
        valid_items.add(Items.field_185167_i);
        if (Loader.isModLoaded((String)"potioncore")) {
            valid_items.add(Item.func_111206_d((String)"potioncore:custom_potion"));
            valid_items.add(Item.func_111206_d((String)"potioncore:custom_arrow"));
        }
        VALID_ITEMS = valid_items.toArray(new Item[valid_items.size()]);
    }

    private boolean canCombineItems(ItemStack stackA, ItemStack stackB) {
        if (ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB)) {
            return true;
        }
        if (stackA.func_77973_b() == Items.field_151068_bn && stackB.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackB.func_77960_j() == 0) {
            return true;
        }
        if (stackA.func_77973_b() == Items.field_185155_bH && stackB.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackB.func_77960_j() == 1) {
            return true;
        }
        if (stackA.func_77973_b() == Items.field_185156_bI && stackB.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackB.func_77960_j() == 2) {
            return true;
        }
        if (stackB.func_77973_b() == Items.field_151068_bn && stackA.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackA.func_77960_j() == 0) {
            return true;
        }
        if (stackB.func_77973_b() == Items.field_185155_bH && stackA.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackA.func_77960_j() == 1) {
            return true;
        }
        if (stackB.func_77973_b() == Items.field_185156_bI && stackA.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_potion") && stackA.func_77960_j() == 2) {
            return true;
        }
        if (stackA.func_77973_b() == Items.field_185167_i && stackB.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_arrow")) {
            return true;
        }
        return stackB.func_77973_b() == Items.field_185167_i && stackA.func_77973_b() == Item.func_111206_d((String)"potioncore:custom_arrow");
    }

    private ItemStack getOutputStack(ItemStack inputStack) {
        Item item = inputStack.func_77973_b();
        if (item == Items.field_151068_bn || item == Item.func_111206_d((String)"potioncore:custom_potion") && inputStack.func_77960_j() == 0) {
            return new ItemStack((Item)Items.field_151068_bn, 1, 0);
        }
        if (item == Items.field_185155_bH || item == Item.func_111206_d((String)"potioncore:custom_potion") && inputStack.func_77960_j() == 1) {
            return new ItemStack((Item)Items.field_185155_bH, 1, 0);
        }
        if (item == Items.field_185156_bI || item == Item.func_111206_d((String)"potioncore:custom_potion") && inputStack.func_77960_j() == 2) {
            return new ItemStack((Item)Items.field_185156_bI, 1, 0);
        }
        if (item == Items.field_185167_i || item == Item.func_111206_d((String)"potioncore:custom_arrow")) {
            return new ItemStack(Items.field_185167_i, 1, 0);
        }
        return ItemStack.field_190927_a;
    }

    private List<PotionEffect> getEffectsFromStack(ItemStack stack) {
        try {
            Method method = Class.forName("com.tmtravlr.potioncore.PotionCoreHelper").getMethod("getEffectsFromStack", ItemStack.class);
            return (List)method.invoke(null, stack);
        }
        catch (Exception ex) {
            CombinedPotions.LOGGER.catching((Throwable)ex);
            return new ArrayList<PotionEffect>();
        }
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }
}

