/*
 * Decompiled with CFR 0.152.
 */
package com.mart.display.common.block;

import com.mart.display.common.DisplaySide;
import com.mart.display.common.block.BlockBase;
import com.mart.display.common.item.ItemDisplayConfigurator;
import com.mart.display.common.registry.ModItems;
import com.mart.display.common.tile.TileDisplay;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDisplay
extends BlockBase {
    private final AxisAlignedBB displayAabb = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.45, 0.8);

    public BlockDisplay(String registryName) {
        super(Material.field_151576_e, registryName);
        this.setCreativeTab(CreativeTabs.field_78031_c);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149713_g(0);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileDisplay tileEntity = (TileDisplay)world.func_175625_s(pos);
        if (world.field_72995_K || tileEntity == null) {
            return;
        }
        if (tileEntity.getItemStack().func_190926_b()) {
            return;
        }
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        EntityItem dropItem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, tileEntity.getItemStack());
        dropItem.func_174869_p();
        world.func_72838_d((Entity)dropItem);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileDisplay tileEntity = (TileDisplay)world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K || tileEntity == null) {
            return true;
        }
        if (player.func_70093_af()) {
            tileEntity.toggleRotation(facing);
            return true;
        }
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == ModItems.displayConfigurator) {
                DisplaySide side = ItemDisplayConfigurator.getDisplaySide(heldItem);
                if (side == DisplaySide.X) {
                    tileEntity.moveItemXAxis();
                } else if (side == DisplaySide.Y) {
                    tileEntity.moveItemYAxis();
                } else if (side == DisplaySide.Z) {
                    tileEntity.moveItemZAxis();
                }
                return true;
            }
            tileEntity.setItem(heldItem, player, hand);
            return true;
        }
        player.func_184609_a(hand);
        tileEntity.extractItem(player);
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDisplay();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.displayAabb;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

