/*
 * Decompiled with CFR 0.152.
 */
package com.mart.display.common.tile;

import com.mart.display.common.tile.TileBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDisplay
extends TileBase
implements ITickable,
ICapabilityProvider {
    private boolean rotation = true;
    private int rotationDegrees = 0;
    private float xAxisCoord = 0.5f;
    private float yAxisCoord = 0.75f;
    private float zAxisCoord = 0.5f;
    private TileDisplayItemHandler itemStackHandler = new TileDisplayItemHandler(this);

    public void func_73660_a() {
    }

    public void extractItem(EntityPlayer player) {
        if (this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            return;
        }
        player.field_71071_by.func_70441_a(this.itemStackHandler.extractItem(0, 64, false));
        this.notifyUpdate();
    }

    public void setItem(ItemStack heldItem, EntityPlayer player, EnumHand hand) {
        if (!this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
            return;
        }
        ItemStack heldItem2 = heldItem.func_77946_l();
        heldItem2.func_190920_e(1);
        this.itemStackHandler.setStackInSlot(0, heldItem2);
        heldItem.func_190920_e(heldItem.func_190916_E() - 1);
        player.func_184611_a(hand, heldItem);
        this.notifyUpdate();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("rotation", this.rotation);
        compound.func_74768_a("rotationDegrees", this.rotationDegrees);
        compound.func_74776_a("xAxisCoord", this.xAxisCoord);
        compound.func_74776_a("yAxisCoord", this.yAxisCoord);
        compound.func_74776_a("zAxisCoord", this.zAxisCoord);
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotation = compound.func_74767_n("rotation");
        this.rotationDegrees = compound.func_74762_e("rotationDegrees");
        this.xAxisCoord = compound.func_74760_g("xAxisCoord");
        this.yAxisCoord = compound.func_74760_g("yAxisCoord");
        this.zAxisCoord = compound.func_74760_g("zAxisCoord");
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
    }

    public ItemStack getItemStack() {
        return this.itemStackHandler.getStackInSlot(0);
    }

    public void toggleRotation(EnumFacing facing) {
        this.rotation = !this.rotation;
        switch (facing) {
            case EAST: {
                this.rotationDegrees = 90;
                break;
            }
            case WEST: {
                this.rotationDegrees = 90;
                break;
            }
            default: {
                this.rotationDegrees = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.notifyUpdate();
        }
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    public void moveItemXAxis() {
        this.xAxisCoord = this.xAxisCoord >= 2.5f ? -1.5f : (this.xAxisCoord += 0.1f);
        if (!this.field_145850_b.field_72995_K) {
            this.notifyUpdate();
        }
    }

    public void moveItemYAxis() {
        this.yAxisCoord = this.yAxisCoord >= 3.0f ? 0.75f : (this.yAxisCoord += 0.1f);
        if (!this.field_145850_b.field_72995_K) {
            this.notifyUpdate();
        }
    }

    public void moveItemZAxis() {
        this.zAxisCoord = this.zAxisCoord >= 2.5f ? -1.5f : (this.zAxisCoord += 0.1f);
        if (!this.field_145850_b.field_72995_K) {
            this.notifyUpdate();
        }
    }

    public float getxAxisCoord() {
        return this.xAxisCoord;
    }

    public float getyAxisCoord() {
        return this.yAxisCoord;
    }

    public float getzAxisCoord() {
        return this.zAxisCoord;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public class TileDisplayItemHandler
    extends ItemStackHandler {
        private final TileDisplay entity;

        public TileDisplayItemHandler(TileDisplay entity) {
            super(1);
            this.entity = entity;
        }

        protected void onContentsChanged(int slot) {
            this.entity.notifyUpdate();
        }
    }
}

