/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.ASM;

import DummyCore.Utils.ASMManager;
import DummyCore.Utils.LoadingUtils;
import DummyCore.Utils.Notifier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DCASMManager
implements IClassTransformer {
    public DCASMManager() {
        try {
            Class.forName("DummyCore.Utils.ASMManager");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        name = transformedName;
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.client.renderer.BlockModelShapes", "net.minecraft.client.renderer.BlockModelShapes")) {
            return this.handleBlockModelShapes(name, basicClass);
        }
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.client.renderer.BlockRendererDispatcher", "net.minecraft.client.renderer.BlockRendererDispatcher")) {
            return this.handleBlockRendererDispatcher(name, basicClass);
        }
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.client.renderer.ItemModelMesher", "net.minecraft.client.renderer.ItemModelMesher")) {
            return this.handleItemModelMesher(name, basicClass);
        }
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer", "net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer")) {
            return this.handleTileEntityItemStackRenderer(name, basicClass);
        }
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraftforge.client.model.ModelLoader", "net.minecraftforge.client.model.ModelLoader")) {
            return this.handleModelLoader(name, basicClass);
        }
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.item.ItemPotion", "net.minecraft.item.ItemPotion")) {
            return this.handlePotionColor(name, basicClass);
        }
        if (basicClass != null) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMManager.checkAnnotationForClass(classNode, "LDummyCore/Utils/DCASMCheck;")) {
                return this.handleClass(name, transformedName, basicClass, classNode, classReader);
            }
        }
        return basicClass;
    }

    public byte[] handlePotionColor(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "getColorFromItemStack", "func_82790_a!&!a", "(Lnet/minecraft/item/ItemStack;I)I", "(Lnet/minecraft/item/ItemStack;I)I!&!(Lzx;I)I");
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new LabelNode());
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/MiscUtils", "getPotionColor", "(Lnet/minecraft/item/ItemStack;I)I", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)new LabelNode());
            mn.instructions.clear();
            mn.instructions.add(newInstructions);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as OPTIONAL, thus the loading can continue normally.", e, false);
            return basic;
        }
    }

    public byte[] handleModelLoader(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "onPostBakeEvent", "onPostBakeEvent", "(Lnet/minecraft/util/IRegistry;)V", "(Lnet/minecraft/util/IRegistry;)V!&!(Ldb;)V");
            FieldInsnNode insertAfter = null;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                FieldInsnNode fin;
                AbstractInsnNode ain = mn.instructions.get(i);
                if (!(ain instanceof FieldInsnNode) || (fin = (FieldInsnNode)ain).getOpcode() != 180 || !fin.owner.equalsIgnoreCase("net/minecraftforge/client/model/ModelLoader") || !fin.name.equalsIgnoreCase("missingVariants") || !fin.desc.equalsIgnoreCase("Ljava/util/Set;")) continue;
                insertAfter = fin;
                break;
            }
            InsnList insert = new InsnList();
            insert.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Set", "clear", "()V", true));
            insert.add((AbstractInsnNode)new LabelNode());
            insert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/ModelLoader", "missingVariants", "Ljava/util/Set;"));
            mn.instructions.insert((AbstractInsnNode)insertAfter, insert);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as OPTIONAL, thus the loading can continue normally.", e, false);
            return basic;
        }
    }

    public byte[] handleTileEntityItemStackRenderer(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "renderByItem", "func_179022_a!&!a", "(Lnet/minecraft/item/ItemStack;)V", "(Lnet/minecraft/item/ItemStack;)V!&!(Lzx;)V");
            LabelNode iflabel = new LabelNode();
            InsnList lst = new InsnList();
            lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
            lst.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/OldTextureHandler", "renderIS", "(Lnet/minecraft/item/ItemStack;)Z", false));
            lst.add((AbstractInsnNode)new JumpInsnNode(153, iflabel));
            lst.add((AbstractInsnNode)new LabelNode());
            lst.add((AbstractInsnNode)new InsnNode(177));
            lst.add((AbstractInsnNode)iflabel);
            lst.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            mn.instructions.insert(mn.instructions.get(1), lst);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as REQUIRED, thus the loading cannot continue.", e, true);
            return basic;
        }
    }

    public byte[] handleItemModelMesher(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "getItemModel", "func_178089_a!&!a", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/client/resources/model/IBakedModel;", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/client/resources/model/IBakedModel;!&!(Lzx;)Lboq;");
            AbstractInsnNode insertAfter = null;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                AbstractInsnNode an = mn.instructions.get(i);
                if (an.getOpcode() != 58 || !(an instanceof VarInsnNode) || ((VarInsnNode)VarInsnNode.class.cast((Object)an)).var != 3) continue;
                insertAfter = an;
                break;
            }
            InsnList lst = new InsnList();
            lst.add((AbstractInsnNode)new LabelNode());
            lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
            lst.add((AbstractInsnNode)new VarInsnNode(25, 3));
            lst.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/OldTextureHandler", "getModelForIS", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/resources/model/IBakedModel;)Lnet/minecraft/client/resources/model/IBakedModel;", false));
            lst.add((AbstractInsnNode)new VarInsnNode(58, 3));
            mn.instructions.insert(insertAfter, lst);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as REQUIRED, thus the loading cannot continue.", e, true);
            return basic;
        }
    }

    public byte[] handleBlockRendererDispatcher(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "getModelFromBlockState", "func_175022_a!&!a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/client/resources/model/IBakedModel;", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/client/resources/model/IBakedModel;!&!(Lalz;Ladq;Lcj;)Lboq;");
            InsnList lst = new InsnList();
            lst.add((AbstractInsnNode)new VarInsnNode(25, 2));
            lst.add((AbstractInsnNode)new VarInsnNode(25, 3));
            lst.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/OldTextureHandler", "handleIWR", "(Lnet/minecraft/client/resources/model/IBakedModel;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/BlockPos;)Lnet/minecraft/client/resources/model/IBakedModel;", false));
            lst.add((AbstractInsnNode)new VarInsnNode(58, 5));
            lst.add((AbstractInsnNode)new LabelNode());
            lst.add((AbstractInsnNode)new VarInsnNode(25, 5));
            mn.instructions.insert(mn.instructions.get(mn.instructions.size() - 3), lst);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as REQUIRED, thus the loading cannot continue.", e, true);
            return basic;
        }
    }

    public byte[] handleBlockModelShapes(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "reloadModels", "func_178124_c!&!c", "()V", "()V!&!()V");
            InsnList lst = new InsnList();
            lst.add((AbstractInsnNode)new LabelNode());
            lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
            lst.add((AbstractInsnNode)new FieldInsnNode(180, name.replace('.', '/'), ASMManager.chooseByEnvironment("bakedModelStore", "field_178129_a"), "Ljava/util/Map;"));
            lst.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/OldTextureHandler", "reloadResourceManager", "(Ljava/util/Map;)V", false));
            mn.instructions.insert(mn.instructions.get(mn.instructions.size() - 3), lst);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as REQUIRED, thus the loading cannot continue.", e, true);
            return basic;
        }
    }

    public byte[] handleClass(String name, String transformedName, byte[] basicClass, ClassNode cn, ClassReader cr) {
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has requested a DummyCore ASM check via DummyCore/Utils/DCASMCheck annotation. Examining...");
        String[] checkedClss = new String[]{};
        for (int i = 0; i < cn.invisibleAnnotations.size(); ++i) {
            AnnotationNode node = (AnnotationNode)cn.invisibleAnnotations.get(i);
            if (!node.desc.equalsIgnoreCase("LDummyCore/Utils/ExistanceCheck;") || node.values == null || node.values.size() <= 0) continue;
            Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has requested a DummyCore ASM check on it's implementations via DummyCore/Utils/ExistanceCheck annotation. Examining...");
            List classes = (List)List.class.cast(node.values.get(1));
            checkedClss = new String[classes.size()];
            checkedClss = (String[])String[].class.cast(classes.toArray(checkedClss));
            break;
        }
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has given the next interfaces to check: " + Arrays.asList(checkedClss));
        ClassWriter cw = new ClassWriter(1);
        if (checkedClss.length > 0) {
            block1: for (int i = 0; i < checkedClss.length; ++i) {
                if (!this.classExists(checkedClss[i])) {
                    for (int j = 0; j < cn.interfaces.size(); ++j) {
                        if (!((String)cn.interfaces.get(j)).equalsIgnoreCase(checkedClss[i].replace('.', '/'))) continue;
                        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has a " + (String)cn.interfaces.get(j) + " implementation, but the referenced class was not found. Removing the given interface.");
                        cn.interfaces.remove(j);
                        continue block1;
                    }
                    continue;
                }
                Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has a " + checkedClss[i] + " implementation, and the referenced class was found. Skipping to the next interface...");
            }
        }
        cn.accept((ClassVisitor)cw);
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has been checked.");
        return cw.toByteArray();
    }

    public boolean classExists(String s) {
        try {
            Class<?> c = Class.forName(s);
            return c != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

