/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Client;

import DummyCore.Client.IBlockConnector;
import DummyCore.Client.IColorProvider;
import DummyCore.Client.ISimpleBlockRenderingHandler;
import DummyCore.Client.Icon;
import DummyCore.Client.ModelBakeryOven;
import DummyCore.Client.RenderAccessLibrary;
import DummyCore.Client.SBRHAwareModel;
import DummyCore.Utils.ExtendedAABB;
import DummyCore.Utils.Notifier;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class DynamicModelBakery {
    public final SBRHAwareModel workedWith;
    public final FaceBakery bakery = new FaceBakery();
    public Icon overrideBlockIcon;
    public boolean inWorldRendering;
    public IBlockAccess world;
    public int x;
    public int y;
    public int z;
    public ExtendedAABB renderBB = new ExtendedAABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public double offsetX;
    public double offsetY;
    public double offsetZ;
    public int faceTint = -1;
    public boolean inverseRender = false;
    public boolean renderAllFaces = false;

    public DynamicModelBakery(SBRHAwareModel offendor) {
        this(offendor, false, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
    }

    public DynamicModelBakery(SBRHAwareModel offendor, boolean world, IBlockAccess w, int x, int y, int z) {
        this.workedWith = offendor;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = w;
        this.inWorldRendering = world;
    }

    public float getFaceBrightness(EnumFacing face) {
        switch (face.ordinal()) {
            case 2: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
            case 5: 
            case 6: {
                return 0.8f;
            }
            case 3: 
            case 4: {
                return 0.6f;
            }
        }
        return 0.5f;
    }

    public int getFaceShadeColor(EnumFacing face) {
        float f = this.getFaceBrightness(face);
        int i = MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | i << 8 | i;
    }

    public void clearRenderOffsets() {
        this.offsetZ = 0.0;
        this.offsetY = 0.0;
        this.offsetX = 0.0;
    }

    public void setRenderOffsets(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void setRenderBoundsFromBlock(Block b) {
        if (this.inWorldRendering) {
            b.func_180654_a(this.world, new BlockPos(this.x, this.y, this.z));
        }
        this.renderBB = new ExtendedAABB(b.func_149704_x(), b.func_149665_z(), b.func_149706_B(), b.func_149753_y(), b.func_149669_A(), b.func_149693_C());
    }

    public void clearRenderBounds() {
        this.renderBB = new ExtendedAABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void setRenderBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.renderBB = new ExtendedAABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Icon chooseIcon(EnumFacing face) {
        return this.overrideBlockIcon == null ? (this.inWorldRendering ? this.workedWith.interfaced.getIcon(this.world, this.x, this.y, this.z, face.ordinal()) : this.workedWith.interfaced.getIcon(face.ordinal(), this.workedWith.rendered.func_176201_c(this.workedWith.blockState))) : this.overrideBlockIcon;
    }

    public void setOverrideBlockTexture(Icon icon) {
        this.overrideBlockIcon = icon;
    }

    public void clearOverrideBlockTexture() {
        this.overrideBlockIcon = null;
    }

    public boolean hasOverrideBlockIcon() {
        return this.overrideBlockIcon != null;
    }

    public void setOverrideBlockColor(int color) {
        this.faceTint = color;
    }

    public void clearOverrideBlockColor() {
        this.faceTint = -1;
    }

    public void addHorizontalFacesWithOffset() {
        this.addHorizontalFacesWithOffset(0.1);
    }

    public void invertRenderPoints() {
        this.inverseRender = !this.inverseRender;
    }

    public void clearRenderInversion() {
        this.inverseRender = false;
    }

    public void disableRenderAllFaces() {
        this.renderAllFaces = false;
    }

    public void forceRenderAllFaces() {
        this.renderAllFaces = true;
    }

    public int findColorFromProvider(EnumFacing side) {
        if (this.inWorldRendering) {
            return ((IColorProvider)IColorProvider.class.cast(this.workedWith.rendered)).getColorFor(this.world, this.x, this.y, this.z, side);
        }
        return this.workedWith.rendered.func_149635_D();
    }

    public void addConnectedBlockFaces() {
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.inWorldRendering) {
            if (this.workedWith.rendered instanceof IBlockConnector) {
                EnumFacing face = EnumFacing.UP;
                IBlockConnector ibc = (IBlockConnector)IBlockConnector.class.cast(this.workedWith.rendered);
                BlockPos bp = new BlockPos(this.x, this.y, this.z);
                for (int i = 2; i < 6; ++i) {
                    EnumFacing st = EnumFacing.func_82600_a((int)i);
                    if (!ibc.connectsTo(this.world, new BlockPos(this.x + st.func_82601_c(), this.y + st.func_96559_d(), this.z + st.func_82599_e()), bp, st, this.workedWith.blockState)) continue;
                    face = st;
                    break;
                }
                if (face != EnumFacing.UP) {
                    this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                    double minRX = this.offsetX + this.renderBB.minX;
                    double maxRX = this.offsetX + this.renderBB.maxX;
                    double minRY = this.offsetY + this.renderBB.minY;
                    double maxRY = this.offsetY + this.renderBB.maxY;
                    double minRZ = this.offsetZ + this.renderBB.minZ;
                    double maxRZ = this.offsetZ + this.renderBB.maxZ;
                    ModelBakeryOven oven = ModelBakeryOven.instance;
                    Icon drawn = this.chooseIcon(EnumFacing.WEST);
                    double minU = drawn.getMinU();
                    double maxU = drawn.getMaxU();
                    double maxV = drawn.getMaxV();
                    double minV = drawn.getMinV();
                    if (this.workedWith.rendered instanceof IColorProvider) {
                        oven.start(EnumFacing.WEST, this.findColorFromProvider(EnumFacing.WEST), true);
                    } else {
                        oven.start(EnumFacing.WEST, this.faceTint);
                    }
                    oven.addVertexWithUV(minRX, maxRY, minRZ, maxU, minV);
                    oven.addVertexWithUV(maxRX, maxRY, maxRZ, minU, minV);
                    oven.addVertexWithUV(maxRX, minRY, maxRZ, minU, maxV);
                    oven.addVertexWithUV(minRX, minRY, minRZ, maxU, maxV);
                    this.addFace(oven.done(), EnumFacing.WEST);
                    drawn = this.chooseIcon(EnumFacing.EAST);
                    minU = drawn.getMinU();
                    maxU = drawn.getMaxU();
                    maxV = drawn.getMaxV();
                    minV = drawn.getMinV();
                    if (this.workedWith.rendered instanceof IColorProvider) {
                        oven.start(EnumFacing.EAST, this.findColorFromProvider(EnumFacing.EAST), true);
                    } else {
                        oven.start(EnumFacing.EAST, this.faceTint);
                    }
                    oven.addVertexWithUV(maxRX, maxRY, maxRZ, maxU, minV);
                    oven.addVertexWithUV(minRX, maxRY, minRZ, minU, minV);
                    oven.addVertexWithUV(minRX, minRY, minRZ, minU, maxV);
                    oven.addVertexWithUV(maxRX, minRY, maxRZ, maxU, maxV);
                    this.addFace(oven.done(), EnumFacing.EAST);
                    drawn = this.chooseIcon(EnumFacing.NORTH);
                    minU = drawn.getMinU();
                    maxU = drawn.getMaxU();
                    maxV = drawn.getMaxV();
                    minV = drawn.getMinV();
                    if (this.workedWith.rendered instanceof IColorProvider) {
                        oven.start(EnumFacing.NORTH, this.findColorFromProvider(EnumFacing.NORTH), true);
                    } else {
                        oven.start(EnumFacing.NORTH, this.faceTint);
                    }
                    oven.addVertexWithUV(maxRX, maxRY, minRZ, maxU, minV);
                    oven.addVertexWithUV(minRX, maxRY, maxRZ, minU, minV);
                    oven.addVertexWithUV(minRX, minRY, maxRZ, minU, maxV);
                    oven.addVertexWithUV(maxRX, minRY, minRZ, maxU, maxV);
                    this.addFace(oven.done(), EnumFacing.NORTH);
                    drawn = this.chooseIcon(EnumFacing.SOUTH);
                    minU = drawn.getMinU();
                    maxU = drawn.getMaxU();
                    maxV = drawn.getMaxV();
                    minV = drawn.getMinV();
                    if (this.workedWith.rendered instanceof IColorProvider) {
                        oven.start(EnumFacing.SOUTH, this.findColorFromProvider(EnumFacing.SOUTH), true);
                    } else {
                        oven.start(EnumFacing.SOUTH, this.faceTint);
                    }
                    oven.addVertexWithUV(minRX, maxRY, maxRZ, maxU, minV);
                    oven.addVertexWithUV(maxRX, maxRY, minRZ, minU, minV);
                    oven.addVertexWithUV(maxRX, minRY, minRZ, minU, maxV);
                    oven.addVertexWithUV(minRX, minRY, maxRZ, maxU, maxV);
                    this.addFace(oven.done(), EnumFacing.SOUTH);
                    this.clearRenderBounds();
                    drawn = ibc.getConnectionIcon(this.world, this.x, this.y, this.z);
                    minU = drawn.getMinU();
                    maxU = drawn.getMaxU();
                    maxV = drawn.getMaxV();
                    minV = drawn.getMinV();
                    minRX = this.offsetX + this.renderBB.minX;
                    maxRX = this.offsetX + this.renderBB.maxX;
                    minRY = this.offsetY + this.renderBB.minY;
                    maxRY = this.offsetY + this.renderBB.maxY;
                    minRZ = this.offsetZ + this.renderBB.minZ;
                    maxRZ = this.offsetZ + this.renderBB.maxZ;
                    double medRX = (minRX + maxRX) / 2.0;
                    double medRZ = (minRZ + maxRZ) / 2.0;
                    if (face == EnumFacing.WEST || face == EnumFacing.EAST) {
                        if (face == EnumFacing.EAST) {
                            minU = drawn.getMaxU();
                            maxU = drawn.getMinU();
                        } else {
                            minU = drawn.getMinU();
                            maxU = drawn.getMaxU();
                        }
                        if (this.workedWith.rendered instanceof IColorProvider) {
                            oven.start(EnumFacing.NORTH, this.findColorFromProvider(EnumFacing.NORTH), true);
                        } else {
                            oven.start(EnumFacing.NORTH, this.faceTint);
                        }
                        oven.addVertexWithUV(maxRX, maxRY, medRZ, maxU, minV);
                        oven.addVertexWithUV(minRX, maxRY, medRZ, minU, minV);
                        oven.addVertexWithUV(minRX, minRY, medRZ, minU, maxV);
                        oven.addVertexWithUV(maxRX, minRY, medRZ, maxU, maxV);
                        this.addFace(oven.done(), EnumFacing.NORTH);
                        if (this.workedWith.rendered instanceof IColorProvider) {
                            oven.start(EnumFacing.SOUTH, this.findColorFromProvider(EnumFacing.WEST), true);
                        } else {
                            oven.start(EnumFacing.SOUTH, this.faceTint);
                        }
                        oven.addVertexWithUV(minRX, maxRY, medRZ, minU, minV);
                        oven.addVertexWithUV(maxRX, maxRY, medRZ, maxU, minV);
                        oven.addVertexWithUV(maxRX, minRY, medRZ, maxU, maxV);
                        oven.addVertexWithUV(minRX, minRY, medRZ, minU, maxV);
                        this.addFace(oven.done(), EnumFacing.SOUTH);
                    }
                    if (face == EnumFacing.SOUTH || face == EnumFacing.NORTH) {
                        if (face == EnumFacing.SOUTH) {
                            minU = drawn.getMaxU();
                            maxU = drawn.getMinU();
                        } else {
                            minU = drawn.getMinU();
                            maxU = drawn.getMaxU();
                        }
                        if (this.workedWith.rendered instanceof IColorProvider) {
                            oven.start(EnumFacing.WEST, this.findColorFromProvider(EnumFacing.WEST), true);
                        } else {
                            oven.start(EnumFacing.WEST, this.faceTint);
                        }
                        oven.addVertexWithUV(medRX, maxRY, minRZ, minU, minV);
                        oven.addVertexWithUV(medRX, maxRY, maxRZ, maxU, minV);
                        oven.addVertexWithUV(medRX, minRY, maxRZ, maxU, maxV);
                        oven.addVertexWithUV(medRX, minRY, minRZ, minU, maxV);
                        this.addFace(oven.done(), EnumFacing.WEST);
                        if (this.workedWith.rendered instanceof IColorProvider) {
                            oven.start(EnumFacing.EAST, this.findColorFromProvider(EnumFacing.EAST), true);
                        } else {
                            oven.start(EnumFacing.EAST, this.faceTint);
                        }
                        oven.addVertexWithUV(medRX, maxRY, maxRZ, maxU, minV);
                        oven.addVertexWithUV(medRX, maxRY, minRZ, minU, minV);
                        oven.addVertexWithUV(medRX, minRY, minRZ, minU, maxV);
                        oven.addVertexWithUV(medRX, minRY, maxRZ, maxU, maxV);
                        this.addFace(oven.done(), EnumFacing.EAST);
                    }
                } else {
                    this.addCrossedSquares();
                }
            } else {
                this.addCrossedSquares();
            }
        } else {
            this.addCrossedSquares();
        }
        this.clearRenderBounds();
    }

    public void addFacesWithOffsetOnHorizontalAxis() {
        this.addFacesWithOffsetOnHorizontalAxis(0.0625);
    }

    public void addFacesWithOffsetOnHorizontalAxis(double offset) {
        this.addFaceYNeg();
        this.addFaceYPos();
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.setRenderOffsets(offset, 0.0, 0.0);
        this.addFaceXNeg();
        this.setRenderOffsets(-offset, 0.0, 0.0);
        this.addFaceXPos();
        this.setRenderOffsets(0.0, 0.0, offset);
        this.addFaceZNeg();
        this.setRenderOffsets(0.0, 0.0, -offset);
        this.addFaceZPos();
        this.clearRenderBounds();
        this.clearRenderOffsets();
    }

    public void addHorizontalFacesWithOffset(double offset) {
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.setRenderOffsets(offset, 0.0, 0.0);
        this.addFaceXNeg();
        this.setRenderOffsets(-offset, 0.0, 0.0);
        this.addFaceXPos();
        this.setRenderOffsets(0.0, 0.0, offset);
        this.addFaceZNeg();
        this.setRenderOffsets(0.0, 0.0, -offset);
        this.addFaceZPos();
        this.invertRenderPoints();
        this.setRenderOffsets(offset, 0.0, 0.0);
        this.addFaceXNeg();
        this.setRenderOffsets(-offset, 0.0, 0.0);
        this.addFaceXPos();
        this.setRenderOffsets(0.0, 0.0, offset);
        this.addFaceZNeg();
        this.setRenderOffsets(0.0, 0.0, -offset);
        this.addFaceZPos();
        this.invertRenderPoints();
        this.clearRenderBounds();
        this.clearRenderOffsets();
    }

    public void addHorizontalCrossedSquares() {
        Icon drawn = this.chooseIcon(EnumFacing.UP);
        double minU = drawn.getMinU();
        double maxU = drawn.getMaxU();
        double minV = drawn.getMinV();
        double maxV = drawn.getMaxV();
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (!this.inWorldRendering && !this.workedWith.func_177556_c()) {
            minRX = this.offsetX;
            maxRX = this.offsetX + 1.0;
            minRY = this.offsetY;
            maxRY = this.offsetY + 1.0;
            minRZ = this.offsetZ;
            maxRZ = this.offsetZ + 1.0;
        }
        double medRX = (minRX + maxRX) / 2.0;
        double medRZ = (minRZ + maxRZ) / 2.0;
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.WEST, this.findColorFromProvider(EnumFacing.WEST), true);
        } else {
            oven.start(EnumFacing.WEST, this.faceTint);
        }
        oven.addVertexWithUV(medRX, maxRY, minRZ, minU, minV);
        oven.addVertexWithUV(medRX, maxRY, maxRZ, maxU, minV);
        oven.addVertexWithUV(medRX, minRY, maxRZ, maxU, maxV);
        oven.addVertexWithUV(medRX, minRY, minRZ, minU, maxV);
        this.addFace(oven.done(), EnumFacing.WEST);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.EAST, this.findColorFromProvider(EnumFacing.EAST), true);
        } else {
            oven.start(EnumFacing.EAST, this.faceTint);
        }
        oven.addVertexWithUV(medRX, maxRY, maxRZ, maxU, minV);
        oven.addVertexWithUV(medRX, maxRY, minRZ, minU, minV);
        oven.addVertexWithUV(medRX, minRY, minRZ, minU, maxV);
        oven.addVertexWithUV(medRX, minRY, maxRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.EAST);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.NORTH, this.findColorFromProvider(EnumFacing.NORTH), true);
        } else {
            oven.start(EnumFacing.NORTH, this.faceTint);
        }
        oven.addVertexWithUV(maxRX, maxRY, medRZ, maxU, minV);
        oven.addVertexWithUV(minRX, maxRY, medRZ, minU, minV);
        oven.addVertexWithUV(minRX, minRY, medRZ, minU, maxV);
        oven.addVertexWithUV(maxRX, minRY, medRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.NORTH);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.SOUTH, this.findColorFromProvider(EnumFacing.SOUTH), true);
        } else {
            oven.start(EnumFacing.SOUTH, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, medRZ, minU, minV);
        oven.addVertexWithUV(maxRX, maxRY, medRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, minRY, medRZ, maxU, maxV);
        oven.addVertexWithUV(minRX, minRY, medRZ, minU, maxV);
        this.addFace(oven.done(), EnumFacing.SOUTH);
    }

    public void addCrossedSquares() {
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (!this.inWorldRendering && !this.workedWith.func_177556_c()) {
            minRX = this.offsetX;
            maxRX = this.offsetX + 1.0;
            minRY = this.offsetY;
            maxRY = this.offsetY + 1.0;
            minRZ = this.offsetZ;
            maxRZ = this.offsetZ + 1.0;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        Icon drawn = this.chooseIcon(EnumFacing.WEST);
        double minU = drawn.getMinU();
        double maxU = drawn.getMaxU();
        double maxV = drawn.getMaxV();
        double minV = drawn.getMinV();
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.WEST, this.findColorFromProvider(EnumFacing.WEST), true);
        } else {
            oven.start(EnumFacing.WEST, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, minRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, maxRY, maxRZ, minU, minV);
        oven.addVertexWithUV(maxRX, minRY, maxRZ, minU, maxV);
        oven.addVertexWithUV(minRX, minRY, minRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.WEST);
        drawn = this.chooseIcon(EnumFacing.EAST);
        minU = drawn.getMinU();
        maxU = drawn.getMaxU();
        maxV = drawn.getMaxV();
        minV = drawn.getMinV();
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.EAST, this.findColorFromProvider(EnumFacing.EAST), true);
        } else {
            oven.start(EnumFacing.EAST, this.faceTint);
        }
        oven.addVertexWithUV(maxRX, maxRY, maxRZ, maxU, minV);
        oven.addVertexWithUV(minRX, maxRY, minRZ, minU, minV);
        oven.addVertexWithUV(minRX, minRY, minRZ, minU, maxV);
        oven.addVertexWithUV(maxRX, minRY, maxRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.EAST);
        drawn = this.chooseIcon(EnumFacing.NORTH);
        minU = drawn.getMinU();
        maxU = drawn.getMaxU();
        maxV = drawn.getMaxV();
        minV = drawn.getMinV();
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.NORTH, this.findColorFromProvider(EnumFacing.NORTH), true);
        } else {
            oven.start(EnumFacing.NORTH, this.faceTint);
        }
        oven.addVertexWithUV(maxRX, maxRY, minRZ, maxU, minV);
        oven.addVertexWithUV(minRX, maxRY, maxRZ, minU, minV);
        oven.addVertexWithUV(minRX, minRY, maxRZ, minU, maxV);
        oven.addVertexWithUV(maxRX, minRY, minRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.NORTH);
        drawn = this.chooseIcon(EnumFacing.SOUTH);
        minU = drawn.getMinU();
        maxU = drawn.getMaxU();
        maxV = drawn.getMaxV();
        minV = drawn.getMinV();
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.SOUTH, this.findColorFromProvider(EnumFacing.SOUTH), true);
        } else {
            oven.start(EnumFacing.SOUTH, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, maxRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, maxRY, minRZ, minU, minV);
        oven.addVertexWithUV(maxRX, minRY, minRZ, minU, maxV);
        oven.addVertexWithUV(minRX, minRY, maxRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.SOUTH);
    }

    public void addCube() {
        this.addFaceYNeg();
        this.addFaceYPos();
        this.addFaceZNeg();
        this.addFaceZPos();
        this.addFaceXNeg();
        this.addFaceXPos();
    }

    public void addFaceXPos() {
        Icon drawn = this.chooseIcon(EnumFacing.EAST);
        double minU = drawn.getInterpolatedU(this.renderBB.minZ * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxZ * 16.0);
        double maxV = drawn.getInterpolatedV(16.0 - this.renderBB.maxY * 16.0);
        double minV = drawn.getInterpolatedV(16.0 - this.renderBB.minY * 16.0);
        if (this.renderBB.minZ < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minY < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxZ > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxY > 1.0) {
            maxV = drawn.getMaxV();
        }
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (this.inverseRender) {
            double d = minRZ;
            minRZ = maxRZ;
            maxRZ = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.EAST, this.findColorFromProvider(EnumFacing.EAST), true);
        } else {
            oven.start(EnumFacing.EAST, this.faceTint);
        }
        oven.addVertexWithUV(maxRX, minRY, maxRZ, minU, minV);
        oven.addVertexWithUV(maxRX, minRY, minRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, maxRY, minRZ, maxU, maxV);
        oven.addVertexWithUV(maxRX, maxRY, maxRZ, minU, maxV);
        this.addFace(oven.done(), EnumFacing.EAST);
    }

    public void addFaceXNeg() {
        Icon drawn = this.chooseIcon(EnumFacing.WEST);
        double minU = drawn.getInterpolatedU(this.renderBB.minZ * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxZ * 16.0);
        double maxV = drawn.getInterpolatedV(16.0 - this.renderBB.maxY * 16.0);
        double minV = drawn.getInterpolatedV(16.0 - this.renderBB.minY * 16.0);
        if (this.renderBB.minZ < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minY < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxZ > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxY > 1.0) {
            maxV = drawn.getMaxV();
        }
        double minRX = this.offsetX + this.renderBB.minX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (this.inverseRender) {
            double d = minRZ;
            minRZ = maxRZ;
            maxRZ = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.WEST, this.findColorFromProvider(EnumFacing.WEST), true);
        } else {
            oven.start(EnumFacing.WEST, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, maxRZ, maxU, maxV);
        oven.addVertexWithUV(minRX, maxRY, minRZ, minU, maxV);
        oven.addVertexWithUV(minRX, minRY, minRZ, minU, minV);
        oven.addVertexWithUV(minRX, minRY, maxRZ, maxU, minV);
        this.addFace(oven.done(), EnumFacing.WEST);
    }

    public void addFaceZPos() {
        Icon drawn = this.chooseIcon(EnumFacing.SOUTH);
        double minU = drawn.getInterpolatedU(this.renderBB.minX * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxX * 16.0);
        double maxV = drawn.getInterpolatedV(16.0 - this.renderBB.maxY * 16.0);
        double minV = drawn.getInterpolatedV(16.0 - this.renderBB.minY * 16.0);
        if (this.renderBB.minX < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minY < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxX > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxY > 1.0) {
            maxV = drawn.getMaxV();
        }
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (this.inverseRender) {
            double d = minRX;
            minRX = maxRX;
            maxRX = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.SOUTH, this.findColorFromProvider(EnumFacing.SOUTH), true);
        } else {
            oven.start(EnumFacing.SOUTH, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, maxRZ, minU, maxV);
        oven.addVertexWithUV(minRX, minRY, maxRZ, minU, minV);
        oven.addVertexWithUV(maxRX, minRY, maxRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, maxRY, maxRZ, maxU, maxV);
        this.addFace(oven.done(), EnumFacing.SOUTH);
    }

    public void addFaceZNeg() {
        Icon drawn = this.chooseIcon(EnumFacing.NORTH);
        double minU = drawn.getInterpolatedU(this.renderBB.minX * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxX * 16.0);
        double maxV = drawn.getInterpolatedV(16.0 - this.renderBB.maxY * 16.0);
        double minV = drawn.getInterpolatedV(16.0 - this.renderBB.minY * 16.0);
        if (this.renderBB.minX < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minY < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxX > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxY > 1.0) {
            maxV = drawn.getMaxV();
        }
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        if (this.inverseRender) {
            double d = minRX;
            minRX = maxRX;
            maxRX = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.NORTH, this.findColorFromProvider(EnumFacing.NORTH), true);
        } else {
            oven.start(EnumFacing.NORTH, this.faceTint);
        }
        oven.addVertexWithUV(minRX, maxRY, minRZ, maxU, maxV);
        oven.addVertexWithUV(maxRX, maxRY, minRZ, minU, maxV);
        oven.addVertexWithUV(maxRX, minRY, minRZ, minU, minV);
        oven.addVertexWithUV(minRX, minRY, minRZ, maxU, minV);
        this.addFace(oven.done(), EnumFacing.NORTH);
    }

    public void addFaceYPos() {
        Icon drawn = this.chooseIcon(EnumFacing.UP);
        double minU = drawn.getInterpolatedU(this.renderBB.minX * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxX * 16.0);
        double minV = drawn.getInterpolatedV(this.renderBB.minZ * 16.0);
        double maxV = drawn.getInterpolatedV(this.renderBB.maxZ * 16.0);
        if (this.renderBB.minX < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minZ < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxX > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxZ > 1.0) {
            maxV = drawn.getMaxV();
        }
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double maxRY = this.offsetY + this.renderBB.maxY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (this.inverseRender) {
            double d = minRX;
            minRX = maxRX;
            maxRX = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.UP, this.findColorFromProvider(EnumFacing.UP), true);
        } else {
            oven.start(EnumFacing.UP, this.faceTint);
        }
        oven.addVertexWithUV(maxRX, maxRY, maxRZ, maxU, maxV);
        oven.addVertexWithUV(maxRX, maxRY, minRZ, maxU, minV);
        oven.addVertexWithUV(minRX, maxRY, minRZ, minU, minV);
        oven.addVertexWithUV(minRX, maxRY, maxRZ, minU, maxV);
        this.addFace(oven.done(), EnumFacing.UP);
    }

    public void addFaceYNeg() {
        Icon drawn = this.chooseIcon(EnumFacing.DOWN);
        double minU = drawn.getInterpolatedU(this.renderBB.minX * 16.0);
        double maxU = drawn.getInterpolatedU(this.renderBB.maxX * 16.0);
        double minV = drawn.getInterpolatedV(this.renderBB.minZ * 16.0);
        double maxV = drawn.getInterpolatedV(this.renderBB.maxZ * 16.0);
        if (this.renderBB.minX < 0.0) {
            minU = drawn.getMinU();
        }
        if (this.renderBB.minZ < 0.0) {
            minV = drawn.getMinV();
        }
        if (this.renderBB.maxX > 1.0) {
            maxU = drawn.getMaxU();
        }
        if (this.renderBB.maxZ > 1.0) {
            maxV = drawn.getMaxV();
        }
        double minRX = this.offsetX + this.renderBB.minX;
        double maxRX = this.offsetX + this.renderBB.maxX;
        double minRY = this.offsetY + this.renderBB.minY;
        double minRZ = this.offsetZ + this.renderBB.minZ;
        double maxRZ = this.offsetZ + this.renderBB.maxZ;
        if (this.inverseRender) {
            double d = minRX;
            minRX = maxRX;
            maxRX = d;
            d = minU;
            minU = maxU;
            maxU = d;
        }
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.DOWN, this.findColorFromProvider(EnumFacing.DOWN), true);
        } else {
            oven.start(EnumFacing.DOWN, this.faceTint);
        }
        oven.addVertexWithUV(minRX, minRY, maxRZ, maxU, maxV);
        oven.addVertexWithUV(minRX, minRY, minRZ, maxU, minV);
        oven.addVertexWithUV(maxRX, minRY, minRZ, minU, minV);
        oven.addVertexWithUV(maxRX, minRY, maxRZ, minU, maxV);
        this.addFace(oven.done(), EnumFacing.DOWN);
    }

    public void addDiamond(double rad, double x, double y, double z) {
        x += this.offsetX;
        y += this.offsetY;
        z += this.offsetZ;
        Icon drawn = this.chooseIcon(EnumFacing.UP);
        double minU = drawn.getMinU();
        double maxU = drawn.getMaxU();
        double maxV = drawn.getMaxV();
        double minV = drawn.getMinV();
        ModelBakeryOven oven = ModelBakeryOven.instance;
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.UP, this.findColorFromProvider(EnumFacing.UP), true);
        } else {
            oven.start(EnumFacing.UP, this.faceTint);
        }
        oven.addVertexWithUV(x + rad / 2.0, y, z + rad / 2.0, maxU, maxV);
        oven.addVertexWithUV(x + rad, y, z, maxU, minV);
        oven.addVertexWithUV(x, y + rad, z, minU, minV);
        oven.addVertexWithUV(x, y, z + rad, minU, maxV);
        this.addFace(oven.done(), EnumFacing.UP);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.UP, this.findColorFromProvider(EnumFacing.UP), true);
        } else {
            oven.start(EnumFacing.UP, this.faceTint);
        }
        oven.addVertexWithUV(x, y, z + rad, maxU, maxV);
        oven.addVertexWithUV(x, y + rad, z, maxU, minV);
        oven.addVertexWithUV(x - rad, y, z, minU, minV);
        oven.addVertexWithUV(x - rad / 2.0, y, z + rad / 2.0, minU, maxV);
        this.addFace(oven.done(), EnumFacing.UP);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.UP, this.findColorFromProvider(EnumFacing.UP), true);
        } else {
            oven.start(EnumFacing.UP, this.faceTint);
        }
        oven.addVertexWithUV(x + rad, y, z, maxU, maxV);
        oven.addVertexWithUV(x + rad / 2.0, y, z - rad / 2.0, maxU, minV);
        oven.addVertexWithUV(x, y, z - rad, minU, minV);
        oven.addVertexWithUV(x, y + rad, z, minU, maxV);
        this.addFace(oven.done(), EnumFacing.UP);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.UP, this.findColorFromProvider(EnumFacing.UP), true);
        } else {
            oven.start(EnumFacing.UP, this.faceTint);
        }
        oven.addVertexWithUV(x, y + rad, z, maxU, maxV);
        oven.addVertexWithUV(x, y, z - rad, maxU, minV);
        oven.addVertexWithUV(x - rad / 2.0, y, z - rad / 2.0, minU, minV);
        oven.addVertexWithUV(x - rad, y, z, minU, maxV);
        this.addFace(oven.done(), EnumFacing.UP);
        drawn = this.chooseIcon(EnumFacing.DOWN);
        minU = drawn.getMinU();
        maxU = drawn.getMaxU();
        maxV = drawn.getMaxV();
        minV = drawn.getMinV();
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.DOWN, this.findColorFromProvider(EnumFacing.DOWN), true);
        } else {
            oven.start(EnumFacing.DOWN, this.faceTint);
        }
        oven.addVertexWithUV(x, y, z + rad, maxU, maxV);
        oven.addVertexWithUV(x, y - rad, z, maxU, minV);
        oven.addVertexWithUV(x + rad, y, z, minU, minV);
        oven.addVertexWithUV(x + rad / 2.0, y, z + rad / 2.0, minU, maxV);
        this.addFace(oven.done(), EnumFacing.DOWN);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.DOWN, this.findColorFromProvider(EnumFacing.DOWN), true);
        } else {
            oven.start(EnumFacing.DOWN, this.faceTint);
        }
        oven.addVertexWithUV(x - rad / 2.0, y, z + rad / 2.0, maxU, maxV);
        oven.addVertexWithUV(x - rad, y, z, maxU, minV);
        oven.addVertexWithUV(x, y - rad, z, minU, minV);
        oven.addVertexWithUV(x, y, z + rad, minU, maxV);
        this.addFace(oven.done(), EnumFacing.DOWN);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.DOWN, this.findColorFromProvider(EnumFacing.DOWN), true);
        } else {
            oven.start(EnumFacing.DOWN, this.faceTint);
        }
        oven.addVertexWithUV(x, y - rad, z, maxU, maxV);
        oven.addVertexWithUV(x, y, z - rad, maxU, minV);
        oven.addVertexWithUV(x + rad / 2.0, y, z - rad / 2.0, minU, minV);
        oven.addVertexWithUV(x + rad, y, z, minU, maxV);
        this.addFace(oven.done(), EnumFacing.DOWN);
        if (this.workedWith.rendered instanceof IColorProvider) {
            oven.start(EnumFacing.DOWN, this.findColorFromProvider(EnumFacing.DOWN), true);
        } else {
            oven.start(EnumFacing.DOWN, this.faceTint);
        }
        oven.addVertexWithUV(x - rad, y, z, maxU, maxV);
        oven.addVertexWithUV(x - rad / 2.0, y, z - rad / 2.0, maxU, minV);
        oven.addVertexWithUV(x, y, z - rad, minU, minV);
        oven.addVertexWithUV(x, y - rad, z, minU, maxV);
        this.addFace(oven.done(), EnumFacing.DOWN);
    }

    public void addFace(int[] vertexData, EnumFacing face) {
        if (this.renderAllFaces) {
            this.addQuad(vertexData);
        } else {
            BakedQuad bq = new BakedQuad(vertexData, this.faceTint, face);
            this.workedWith.faces.get(face).add(bq);
        }
    }

    public void addQuad(int[] vertexData) {
        BakedQuad bq = new BakedQuad(vertexData, this.faceTint, EnumFacing.UP);
        this.workedWith.quads.add(bq);
    }

    public void doBakeModelForIS(ItemStack stk) {
        int id = this.workedWith.interfaced.getDCRenderID();
        if (!RenderAccessLibrary.renderers.containsKey(id)) {
            id = 0;
        }
        ArrayList<ISimpleBlockRenderingHandler> isbrhal = RenderAccessLibrary.renderers.get(id);
        for (ISimpleBlockRenderingHandler isbrh : isbrhal) {
            try {
                isbrh.renderInventoryBlock(stk, this, this.workedWith);
            }
            catch (Exception e) {
                Notifier.notifyErrorCustomMod("DCRenderLibrary", "Catched an exception whlist trying to render " + this.workedWith.rendered + " as IS [" + stk + "]" + " on " + isbrh);
                e.printStackTrace();
            }
        }
    }

    public void doBakeModelInWorld(IBlockState state, IBlockAccess world, BlockPos pos) {
        int id = this.workedWith.interfaced.getDCRenderID();
        if (!RenderAccessLibrary.renderers.containsKey(id)) {
            id = -1;
        }
        ArrayList<ISimpleBlockRenderingHandler> isbrhal = RenderAccessLibrary.renderers.get(id);
        for (ISimpleBlockRenderingHandler isbrh : isbrhal) {
            try {
                isbrh.renderWorldBlock(world, this.workedWith.rendered, pos, this, this.workedWith);
            }
            catch (Exception e) {
                Notifier.notifyErrorCustomMod("DCRenderLibrary", "Catched an exception whlist trying to render " + this.workedWith.rendered + " at [" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "] in " + world + " on " + isbrh);
                e.printStackTrace();
            }
        }
    }
}

