/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Client;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;

public class ModelBakeryOven {
    public int[] data;
    public int quad = 0;
    public int shadeColor = -1;
    public int uselessInt = 0;
    public EnumFacing workedWith;
    public boolean swapRB;
    public static final ModelBakeryOven instance = new ModelBakeryOven();

    public void start(EnumFacing face) {
        this.start(face, -1);
    }

    public void start(EnumFacing face, int shadeColor) {
        this.start(face, shadeColor, false);
    }

    public void start(EnumFacing face, int shadeColor, boolean swapRB) {
        this.workedWith = face;
        this.quad = 0;
        this.shadeColor = shadeColor;
        this.swapRB = swapRB;
        this.data = new int[28];
    }

    public float getFaceBrightness(EnumFacing face) {
        switch (face.ordinal()) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
            case 2: 
            case 3: {
                return 0.8f;
            }
            case 4: 
            case 5: {
                return 0.6f;
            }
        }
        return 0.5f;
    }

    public int getFaceShadeColor(EnumFacing face) {
        float f = this.getFaceBrightness(face);
        int i = MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | i << 8 | i;
    }

    public int getFaceSwappedColor(EnumFacing face, int color) {
        if (color == 0xFFFFFF) {
            return 0xFFFFFF;
        }
        if (color == -1) {
            return -1;
        }
        int hA = (color & 0xFF000000) >> 24;
        if (hA == 0) {
            hA = 255;
        }
        int hB = (color & 0xFF0000) >> 16;
        int hG = (color & 0xFF00) >> 8;
        int hR = color & 0xFF;
        return (hA << 24) + (hR << 16) + (hG << 8) + hB;
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        int l = this.quad * 7;
        this.data[l] = Float.floatToRawIntBits((float)x);
        this.data[l + 1] = Float.floatToRawIntBits((float)y);
        this.data[l + 2] = Float.floatToRawIntBits((float)z);
        this.data[l + 3] = this.shadeColor == -1 ? this.getFaceShadeColor(this.workedWith) : (this.swapRB ? this.getFaceSwappedColor(this.workedWith, this.shadeColor) : this.shadeColor);
        this.data[l + 4] = Float.floatToRawIntBits((float)u);
        this.data[l + 5] = Float.floatToRawIntBits((float)v);
        this.data[l + 6] = this.uselessInt;
        if (this.quad < 3) {
            ++this.quad;
        }
    }

    public int[] done() {
        int[] vertexData = (int[])this.data.clone();
        ForgeHooksClient.fillNormal((int[])vertexData, (EnumFacing)this.workedWith);
        return vertexData;
    }
}

